/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.config;

import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import vip.lematech.hrun4j.config.RunnerConfig;
import vip.lematech.hrun4j.helper.FilesHelper;
import vip.lematech.hrun4j.helper.LogHelper;

public class Env {
    private static Map<String, Object> envMap;

    public static Map<String, Object> getEnvMap() {
        if (envMap == null) {
            Env.initializeEnv();
        }
        return envMap;
    }

    private static synchronized void initializeEnv() {
        if (envMap == null) {
            RunnerConfig.RunMode runMode = RunnerConfig.getInstance().getRunMode();
            envMap = new HashMap<String, Object>();
            envMap.putAll(System.getenv());
            Properties properties = new Properties();
            try {
                String envFilePath = runMode == RunnerConfig.RunMode.POM ? ".env" : RunnerConfig.getInstance().getDotEnvPath();
                File searchFile = null;
                if (runMode == RunnerConfig.RunMode.CLI) {
                    searchFile = FileUtil.isAbsolutePath((String)envFilePath) ? new File(envFilePath) : new File(RunnerConfig.getInstance().getWorkDirectory(), FilesHelper.filePathDecode(envFilePath));
                } else if (runMode == RunnerConfig.RunMode.POM) {
                    URL url = Thread.currentThread().getContextClassLoader().getResource(envFilePath);
                    searchFile = new File(FilesHelper.filePathDecode(url.getPath()));
                }
                if (FileUtil.exist(searchFile)) {
                    properties.load(new FileInputStream(searchFile));
                    envMap.putAll(properties);
                } else {
                    String exceptionMsg = ".env is not exist";
                    LogHelper.warn(exceptionMsg, new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogHelper.error("An error occurred loading the.env file", new Object[0]);
            }
        }
    }

    public static void setEnv(String key, Object value) {
        if (envMap == null) {
            Env.initializeEnv();
        }
        envMap.put(key, value);
    }

    public static Object getEnv(String key) {
        Object value = null;
        if (envMap == null) {
            Env.initializeEnv();
        }
        if (envMap.containsKey(key)) {
            value = envMap.get(key);
        }
        return value;
    }
}

