/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader.selenium;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.downloader.selenium.WebDriverPool;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;

public class SeleniumDownloader
implements Downloader,
Closeable {
    private volatile WebDriverPool webDriverPool;
    private Logger logger = Logger.getLogger(this.getClass());
    private int sleepTime = 0;
    private int poolSize = 1;
    private static final String DRIVER_PHANTOMJS = "phantomjs";

    public SeleniumDownloader(String chromeDriverPath) {
        System.getProperties().setProperty("webdriver.chrome.driver", chromeDriverPath);
    }

    public SeleniumDownloader() {
    }

    public SeleniumDownloader setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
        return this;
    }

    public Page download(Request request, Task task) {
        WebDriver webDriver;
        this.checkInit();
        try {
            webDriver = this.webDriverPool.get();
        }
        catch (InterruptedException e) {
            this.logger.warn((Object)"interrupted", (Throwable)e);
            return null;
        }
        this.logger.info((Object)("downloading page " + request.getUrl()));
        webDriver.get(request.getUrl());
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        WebDriver.Options manage = webDriver.manage();
        Site site = task.getSite();
        if (site.getCookies() != null) {
            for (Map.Entry cookieEntry : site.getCookies().entrySet()) {
                Cookie cookie = new Cookie((String)cookieEntry.getKey(), (String)cookieEntry.getValue());
                manage.addCookie(cookie);
            }
        }
        WebElement webElement = webDriver.findElement(By.xpath((String)"/html"));
        String content = webElement.getAttribute("outerHTML");
        Page page = new Page();
        page.setRawText(content);
        page.setHtml(new Html(content, request.getUrl()));
        page.setUrl((Selectable)new PlainText(request.getUrl()));
        page.setRequest(request);
        this.webDriverPool.returnToPool(webDriver);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInit() {
        if (this.webDriverPool == null) {
            SeleniumDownloader seleniumDownloader = this;
            synchronized (seleniumDownloader) {
                this.webDriverPool = new WebDriverPool(this.poolSize);
            }
        }
    }

    public void setThread(int thread) {
        this.poolSize = thread;
    }

    @Override
    public void close() throws IOException {
        this.webDriverPool.closeAll();
    }
}

