/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.xpath.XPathEvaluator;
import org.apache.log4j.Logger;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.DomSerializer;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import us.codecraft.webmagic.selector.Selector;

public class Xpath2Selector
implements Selector {
    private String xpathStr;
    private XPathExpression xPathExpression;
    private Logger logger = Logger.getLogger(this.getClass());

    public Xpath2Selector(String xpathStr) {
        this.xpathStr = xpathStr;
        try {
            this.init();
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("XPath error!", e);
        }
    }

    private void init() throws XPathExpressionException {
        XPathEvaluator xPathEvaluator = new XPathEvaluator();
        xPathEvaluator.setNamespaceContext((NamespaceContext)XPath2NamespaceContext.INSTANCE);
        this.xPathExpression = xPathEvaluator.compile(this.xpathStr);
    }

    public String select(String text) {
        try {
            Object result;
            HtmlCleaner htmlCleaner = new HtmlCleaner();
            TagNode tagNode = htmlCleaner.clean(text);
            Document document = new DomSerializer(new CleanerProperties()).createDOM(tagNode);
            try {
                result = this.xPathExpression.evaluate(document, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                result = this.xPathExpression.evaluate(document, XPathConstants.STRING);
            }
            if (result instanceof NodeList) {
                NodeList nodeList = (NodeList)result;
                if (nodeList.getLength() == 0) {
                    return null;
                }
                Node item = nodeList.item(0);
                if (item.getNodeType() == 2 || item.getNodeType() == 3) {
                    return item.getTextContent();
                }
                StreamResult xmlOutput = new StreamResult(new StringWriter());
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(item), xmlOutput);
                return xmlOutput.getWriter().toString();
            }
            return result.toString();
        }
        catch (Exception e) {
            this.logger.error((Object)("select text error! " + this.xpathStr), (Throwable)e);
            return null;
        }
    }

    public List<String> selectList(String text) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            Object result;
            HtmlCleaner htmlCleaner = new HtmlCleaner();
            TagNode tagNode = htmlCleaner.clean(text);
            Document document = new DomSerializer(new CleanerProperties()).createDOM(tagNode);
            try {
                result = this.xPathExpression.evaluate(document, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                result = this.xPathExpression.evaluate(document, XPathConstants.STRING);
            }
            if (result instanceof NodeList) {
                NodeList nodeList = (NodeList)result;
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                StreamResult xmlOutput = new StreamResult();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node item = nodeList.item(i);
                    if (item.getNodeType() == 2 || item.getNodeType() == 3) {
                        results.add(item.getTextContent());
                        continue;
                    }
                    xmlOutput.setWriter(new StringWriter());
                    transformer.transform(new DOMSource(item), xmlOutput);
                    results.add(xmlOutput.getWriter().toString());
                }
            } else {
                results.add(result.toString());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("select text error! " + this.xpathStr), (Throwable)e);
        }
        return results;
    }

    static enum XPath2NamespaceContext implements NamespaceContext
    {
        INSTANCE;

        private final Map<String, String> prefix2NamespaceMap = new ConcurrentHashMap<String, String>();
        private final Map<String, List<String>> namespace2PrefixMap = new ConcurrentHashMap<String, List<String>>();

        private void put(String prefix, String namespaceURI) {
            this.prefix2NamespaceMap.put(prefix, namespaceURI);
            List<String> prefixes = this.namespace2PrefixMap.get(namespaceURI);
            if (prefixes == null) {
                prefixes = new ArrayList<String>();
                this.namespace2PrefixMap.put(namespaceURI, prefixes);
            }
            prefixes.add(prefix);
        }

        private XPath2NamespaceContext() {
            this.put("fn", "http://www.w3.org/2005/xpath-functions");
            this.put("xslt", "http://www.w3.org/1999/XSL/Transform");
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.prefix2NamespaceMap.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            List<String> prefixes = this.namespace2PrefixMap.get(namespaceURI);
            if (prefixes == null || prefixes.size() < 1) {
                return null;
            }
            return prefixes.get(0);
        }

        public Iterator getPrefixes(String namespaceURI) {
            List<String> prefixes = this.namespace2PrefixMap.get(namespaceURI);
            if (prefixes == null || prefixes.size() < 1) {
                return null;
            }
            return prefixes.iterator();
        }
    }
}

