/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.pipeline;

import com.alibaba.fastjson.JSON;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.utils.FilePersistentBase;

public class JsonFilePipeline
extends FilePersistentBase
implements Pipeline {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public JsonFilePipeline() {
        this.setPath("/data/webmagic");
    }

    public JsonFilePipeline(String path) {
        this.setPath(path);
    }

    public void process(ResultItems resultItems, Task task) {
        String path = this.path + PATH_SEPERATOR + task.getUUID() + PATH_SEPERATOR;
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.getFile(path + DigestUtils.md5Hex((String)resultItems.getRequest().getUrl()) + ".json")));
            printWriter.write(JSON.toJSONString((Object)resultItems.getAll()));
            printWriter.close();
        }
        catch (IOException e) {
            this.logger.warn("write file error", (Throwable)e);
        }
    }
}

