/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import us.codecraft.webmagic.MultiPageModel;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.utils.DoubleKeyMap;
import us.codecraft.webmagic.utils.Experimental;

@Experimental
public class MultiPagePipeline
implements Pipeline {
    private DoubleKeyMap<String, String, Boolean> pageMap = new DoubleKeyMap(ConcurrentHashMap.class);
    private DoubleKeyMap<String, String, MultiPageModel> objectMap = new DoubleKeyMap(ConcurrentHashMap.class);

    public void process(ResultItems resultItems, Task task) {
        Map resultItemsAll = resultItems.getAll();
        Iterator<Map.Entry<String, Object>> iterator = resultItemsAll.entrySet().iterator();
        while (iterator.hasNext()) {
            this.handleObject(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleObject(Iterator<Map.Entry<String, Object>> iterator) {
        Map.Entry<String, Object> objectEntry = iterator.next();
        Object o = objectEntry.getValue();
        if (o instanceof MultiPageModel) {
            MultiPageModel multiPageModel = (MultiPageModel)o;
            this.pageMap.put(multiPageModel.getPageKey(), multiPageModel.getPage(), Boolean.FALSE);
            Map<String, Boolean> map = this.pageMap.get(multiPageModel.getPageKey());
            synchronized (map) {
                this.pageMap.put(multiPageModel.getPageKey(), multiPageModel.getPage(), Boolean.TRUE);
                if (multiPageModel.getOtherPages() != null) {
                    for (String otherPage : multiPageModel.getOtherPages()) {
                        Boolean aBoolean = this.pageMap.get(multiPageModel.getPageKey(), otherPage);
                        if (aBoolean != null) continue;
                        this.pageMap.put(multiPageModel.getPageKey(), otherPage, Boolean.FALSE);
                    }
                }
                Map<String, Boolean> booleanMap = this.pageMap.get(multiPageModel.getPageKey());
                this.objectMap.put(multiPageModel.getPageKey(), multiPageModel.getPage(), multiPageModel);
                if (booleanMap == null) {
                    return;
                }
                for (Map.Entry<String, Boolean> stringBooleanEntry : booleanMap.entrySet()) {
                    if (stringBooleanEntry.getValue().booleanValue()) continue;
                    iterator.remove();
                    return;
                }
                ArrayList<Map.Entry<String, MultiPageModel>> entryList = new ArrayList<Map.Entry<String, MultiPageModel>>();
                entryList.addAll(this.objectMap.get(multiPageModel.getPageKey()).entrySet());
                if (entryList.size() != 0) {
                    Collections.sort(entryList, new Comparator<Map.Entry<String, MultiPageModel>>(){

                        @Override
                        public int compare(Map.Entry<String, MultiPageModel> o1, Map.Entry<String, MultiPageModel> o2) {
                            try {
                                int i1 = Integer.parseInt(o1.getKey());
                                int i2 = Integer.parseInt(o2.getKey());
                                return i1 - i2;
                            }
                            catch (NumberFormatException e) {
                                return o1.getKey().compareTo(o2.getKey());
                            }
                        }
                    });
                    MultiPageModel value = (MultiPageModel)((Map.Entry)entryList.get(0)).getValue();
                    for (int i = 1; i < entryList.size(); ++i) {
                        value = value.combine((MultiPageModel)((Map.Entry)entryList.get(i)).getValue());
                    }
                    objectEntry.setValue(value);
                }
            }
        }
    }
}

