/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.proxy.Proxy;
import us.codecraft.webmagic.utils.FilePersistentBase;
import us.codecraft.webmagic.utils.ProxyUtils;

public class ProxyPool {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private BlockingQueue<Proxy> proxyQueue = new DelayQueue<Proxy>();
    private Map<String, Proxy> allProxy = new ConcurrentHashMap<String, Proxy>();
    private int reuseInterval = 1500;
    private int reviveTime = 0x6DDD00;
    private int saveProxyInterval = 600000;
    private boolean isEnable = false;
    private boolean validateWhenInit = false;
    private String proxyFilePath = "/data/webmagic/lastUse.proxy";
    private FilePersistentBase fBase = new FilePersistentBase();
    private Timer timer = new Timer(true);
    private TimerTask saveProxyTask = new TimerTask(){

        @Override
        public void run() {
            ProxyPool.this.saveProxyList();
            ProxyPool.this.logger.info(ProxyPool.this.allProxyStatus());
        }
    };

    public ProxyPool() {
        this(null, true);
    }

    public ProxyPool(List<String[]> httpProxyList) {
        this(httpProxyList, true);
    }

    public ProxyPool(List<String[]> httpProxyList, boolean isUseLastProxy) {
        if (httpProxyList != null) {
            this.addProxy((String[][])httpProxyList.toArray((T[])new String[httpProxyList.size()][]));
        }
        if (isUseLastProxy) {
            if (!new File(this.proxyFilePath).exists()) {
                this.setFilePath();
            }
            this.readProxyList();
            this.timer.schedule(this.saveProxyTask, 0L, (long)this.saveProxyInterval);
        }
    }

    private void setFilePath() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        String path = tmpDir + FilePersistentBase.PATH_SEPERATOR + "webmagic" + FilePersistentBase.PATH_SEPERATOR + "lastUse.proxy";
        if (tmpDir != null && new File(tmpDir).isDirectory()) {
            this.fBase.setPath(tmpDir + FilePersistentBase.PATH_SEPERATOR + "webmagic");
            File f = this.fBase.getFile(path);
            if (!f.exists()) {
                try {
                    f.createNewFile();
                }
                catch (IOException e) {
                    this.logger.error("proxy file create error", (Throwable)e);
                }
            }
        } else {
            this.logger.error("java tmp dir not exists");
        }
        this.proxyFilePath = path;
    }

    private void saveProxyList() {
        if (this.allProxy.size() == 0) {
            return;
        }
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.fBase.getFile(this.proxyFilePath)));
            os.writeObject(this.prepareForSaving());
            os.close();
            this.logger.info("save proxy");
        }
        catch (FileNotFoundException e) {
            this.logger.error("proxy file not found", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map<String, Proxy> prepareForSaving() {
        HashMap<String, Proxy> tmp = new HashMap<String, Proxy>();
        for (Map.Entry<String, Proxy> e : this.allProxy.entrySet()) {
            Proxy p = e.getValue();
            p.setFailedNum(0);
            tmp.put(e.getKey(), p);
        }
        return tmp;
    }

    private void readProxyList() {
        try {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(this.fBase.getFile(this.proxyFilePath)));
            this.addProxy((Map)is.readObject());
            is.close();
        }
        catch (FileNotFoundException e) {
            this.logger.info("last use proxy file not found", (Throwable)e);
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void addProxy(Map<String, Proxy> httpProxyMap) {
        this.isEnable = true;
        for (Map.Entry<String, Proxy> entry : httpProxyMap.entrySet()) {
            try {
                if (this.allProxy.containsKey(entry.getKey()) || this.validateWhenInit && !ProxyUtils.validateProxy(entry.getValue().getHttpHost())) continue;
                entry.getValue().setFailedNum(0);
                entry.getValue().setReuseTimeInterval(this.reuseInterval);
                this.proxyQueue.add(entry.getValue());
                this.allProxy.put(entry.getKey(), entry.getValue());
            }
            catch (NumberFormatException e) {
                this.logger.error("HttpHost init error:", (Throwable)e);
            }
        }
        this.logger.info("proxy pool size>>>>" + this.allProxy.size());
    }

    public void addProxy(String[] ... httpProxyList) {
        this.isEnable = true;
        for (String[] s : httpProxyList) {
            try {
                if (this.allProxy.containsKey(s[0])) continue;
                HttpHost item = new HttpHost(InetAddress.getByName(s[0]), Integer.valueOf(s[1]).intValue());
                if (this.validateWhenInit && !ProxyUtils.validateProxy(item)) continue;
                Proxy p = new Proxy(item, this.reuseInterval);
                this.proxyQueue.add(p);
                this.allProxy.put(s[0], p);
            }
            catch (NumberFormatException e) {
                this.logger.error("HttpHost init error:", (Throwable)e);
            }
            catch (UnknownHostException e) {
                this.logger.error("HttpHost init error:", (Throwable)e);
            }
        }
        this.logger.info("proxy pool size>>>>" + this.allProxy.size());
    }

    public HttpHost getProxy() {
        Proxy proxy = null;
        try {
            Long time = System.currentTimeMillis();
            proxy = this.proxyQueue.take();
            double costTime = (double)(System.currentTimeMillis() - time) / 1000.0;
            if (costTime > (double)this.reuseInterval) {
                this.logger.info("get proxy time >>>> " + costTime);
            }
            Proxy p = this.allProxy.get(proxy.getHttpHost().getAddress().getHostAddress());
            p.setLastBorrowTime(System.currentTimeMillis());
            p.borrowNumIncrement(1);
        }
        catch (InterruptedException e) {
            this.logger.error("get proxy error", (Throwable)e);
        }
        if (proxy == null) {
            throw new NoSuchElementException();
        }
        return proxy.getHttpHost();
    }

    public void returnProxy(HttpHost host, int statusCode) {
        Proxy p = this.allProxy.get(host.getAddress().getHostAddress());
        if (p == null) {
            return;
        }
        switch (statusCode) {
            case 200: {
                p.setReuseTimeInterval(this.reuseInterval);
                p.setFailedNum(0);
                p.setFailedErrorType(new ArrayList<Integer>());
                p.recordResponse();
                p.successNumIncrement(1);
                break;
            }
            case 403: {
                p.fail(403);
                p.setReuseTimeInterval(this.reuseInterval * p.getFailedNum());
                this.logger.info(host + " >>>> reuseTimeInterval is >>>> " + (double)p.getReuseTimeInterval() / 1000.0);
                break;
            }
            case 10000: {
                p.fail(10000);
                p.setReuseTimeInterval(600000 * p.getFailedNum());
                this.logger.warn("this proxy is banned >>>> " + p.getHttpHost());
                this.logger.info(host + " >>>> reuseTimeInterval is >>>> " + (double)p.getReuseTimeInterval() / 1000.0);
                break;
            }
            case 404: {
                break;
            }
            default: {
                p.fail(statusCode);
            }
        }
        if (p.getFailedNum() > 20) {
            p.setReuseTimeInterval(this.reviveTime);
            this.logger.error("remove proxy >>>> " + host + ">>>>" + p.getFailedType() + " >>>> remain proxy >>>> " + this.proxyQueue.size());
            return;
        }
        if (p.getFailedNum() > 0 && p.getFailedNum() % 5 == 0 && !ProxyUtils.validateProxy(host)) {
            p.setReuseTimeInterval(this.reviveTime);
            this.logger.error("remove proxy >>>> " + host + ">>>>" + p.getFailedType() + " >>>> remain proxy >>>> " + this.proxyQueue.size());
            return;
        }
        try {
            this.proxyQueue.put(p);
        }
        catch (InterruptedException e) {
            this.logger.warn("proxyQueue return proxy error", (Throwable)e);
        }
    }

    public String allProxyStatus() {
        String re = "all proxy info >>>> \n";
        for (Map.Entry<String, Proxy> entry : this.allProxy.entrySet()) {
            re = re + entry.getValue().toString() + "\n";
        }
        return re;
    }

    public int getIdleNum() {
        return this.proxyQueue.size();
    }

    public int getReuseInterval() {
        return this.reuseInterval;
    }

    public void setReuseInterval(int reuseInterval) {
        this.reuseInterval = reuseInterval;
    }

    public void enable(boolean isEnable) {
        this.isEnable = isEnable;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public int getReviveTime() {
        return this.reviveTime;
    }

    public void setReviveTime(int reviveTime) {
        this.reviveTime = reviveTime;
    }

    public boolean isValidateWhenInit() {
        return this.validateWhenInit;
    }

    public void validateWhenInit(boolean validateWhenInit) {
        this.validateWhenInit = validateWhenInit;
    }

    public int getSaveProxyInterval() {
        return this.saveProxyInterval;
    }

    public void setSaveProxyInterval(int saveProxyInterval) {
        this.saveProxyInterval = saveProxyInterval;
    }

    public String getProxyFilePath() {
        return this.proxyFilePath;
    }

    public void setProxyFilePath(String proxyFilePath) {
        this.proxyFilePath = proxyFilePath;
    }
}

