/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.proxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.proxy.Proxy;
import us.codecraft.webmagic.proxy.ProxyUtil;

public class ProxyPool {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private BlockingQueue<Proxy> proxyQueue = new DelayQueue<Proxy>();
    private Map<String, Proxy> allProxy = new ConcurrentHashMap<String, Proxy>();
    private int reuseInterval = 1500;
    private int reviveTime = 0x6DDD00;
    private boolean isEnable = false;
    private boolean validateWhenInit = false;
    private String proxyFile = "data/lastUse.proxy";
    private Timer timer = new Timer(true);
    private TimerTask saveProxyTask = new TimerTask(){

        @Override
        public void run() {
            ProxyPool.this.saveProxyList();
            ProxyPool.this.logger.info(ProxyPool.this.allProxyStatus());
        }
    };

    public ProxyPool() {
    }

    public ProxyPool(List<String[]> httpProxyList) {
        this.readProxyList();
        this.addProxy((String[][])httpProxyList.toArray((T[])new String[httpProxyList.size()][]));
        this.timer.schedule(this.saveProxyTask, 600000L, 600000L);
    }

    private void saveProxyList() {
        if (this.allProxy.size() == 0) {
            return;
        }
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.proxyFile));
            os.writeObject(this.prepareForSaving());
            os.close();
            this.logger.info("save proxy");
        }
        catch (FileNotFoundException e) {
            this.logger.error("proxy file not found", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map<String, Proxy> prepareForSaving() {
        HashMap<String, Proxy> tmp = new HashMap<String, Proxy>();
        for (Map.Entry<String, Proxy> e : this.allProxy.entrySet()) {
            Proxy p = e.getValue();
            p.setFailedNum(0);
            tmp.put(e.getKey(), p);
        }
        return tmp;
    }

    private void readProxyList() {
        try {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(this.proxyFile));
            this.addProxy((Map)is.readObject());
            is.close();
        }
        catch (FileNotFoundException e) {
            this.logger.error("proxy file not found", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void addProxy(Map<String, Proxy> httpProxyMap) {
        this.isEnable = true;
        for (Map.Entry<String, Proxy> entry : httpProxyMap.entrySet()) {
            try {
                if (this.allProxy.containsKey(entry.getKey()) || this.validateWhenInit && !ProxyUtil.validateProxy(entry.getValue().getHttpHost())) continue;
                entry.getValue().setFailedNum(0);
                entry.getValue().setReuseTimeInterval(this.reuseInterval);
                this.proxyQueue.add(entry.getValue());
                this.allProxy.put(entry.getKey(), entry.getValue());
            }
            catch (NumberFormatException e) {
                this.logger.error("HttpHost init error:", (Throwable)e);
            }
        }
        this.logger.info("proxy pool size>>>>" + this.allProxy.size());
    }

    public void addProxy(String[] ... httpProxyList) {
        this.isEnable = true;
        for (String[] s : httpProxyList) {
            try {
                if (this.allProxy.containsKey(s[0])) continue;
                HttpHost item = new HttpHost(InetAddress.getByName(s[0]), Integer.valueOf(s[1]).intValue());
                if (this.validateWhenInit && !ProxyUtil.validateProxy(item)) continue;
                Proxy p = new Proxy(item, this.reuseInterval);
                this.proxyQueue.add(p);
                this.allProxy.put(s[0], p);
            }
            catch (NumberFormatException e) {
                this.logger.error("HttpHost init error:", (Throwable)e);
            }
            catch (UnknownHostException e) {
                this.logger.error("HttpHost init error:", (Throwable)e);
            }
        }
        this.logger.info("proxy pool size>>>>" + this.allProxy.size());
    }

    public HttpHost getProxy() {
        Proxy proxy = null;
        try {
            Long time = System.currentTimeMillis();
            proxy = this.proxyQueue.take();
            double costTime = (double)(System.currentTimeMillis() - time) / 1000.0;
            if (costTime > (double)this.reuseInterval) {
                this.logger.info("get proxy time >>>> " + costTime);
            }
            Proxy p = this.allProxy.get(proxy.getHttpHost().getAddress().getHostAddress());
            p.setLastBorrowTime(System.currentTimeMillis());
            p.borrowNumIncrement(1);
        }
        catch (InterruptedException e) {
            this.logger.error("get proxy error", (Throwable)e);
        }
        if (proxy == null) {
            throw new NoSuchElementException();
        }
        return proxy.getHttpHost();
    }

    public void returnProxy(HttpHost host, int statusCode) {
        Proxy p = this.allProxy.get(host.getAddress().getHostAddress());
        if (p == null) {
            return;
        }
        switch (statusCode) {
            case 200: {
                p.setReuseTimeInterval(this.reuseInterval);
                p.setFailedNum(0);
                p.setFailedErrorType(new ArrayList<Integer>());
                p.recordResponse();
                p.successNumIncrement(1);
                break;
            }
            case 403: {
                p.fail(403);
                p.setReuseTimeInterval(this.reuseInterval * p.getFailedNum());
                this.logger.info(host + " >>>> reuseTimeInterval is >>>> " + (double)p.getReuseTimeInterval() / 1000.0);
                break;
            }
            case 10000: {
                p.fail(10000);
                p.setReuseTimeInterval(600000 * p.getFailedNum());
                this.logger.warn("this proxy is banned >>>> " + p.getHttpHost());
                this.logger.info(host + " >>>> reuseTimeInterval is >>>> " + (double)p.getReuseTimeInterval() / 1000.0);
                break;
            }
            case 404: {
                break;
            }
            default: {
                p.fail(statusCode);
            }
        }
        if (p.getFailedNum() > 20) {
            p.setReuseTimeInterval(this.reviveTime);
            this.logger.error("remove proxy >>>> " + host + ">>>>" + p.getFailedType() + " >>>> remain proxy >>>> " + this.proxyQueue.size());
            return;
        }
        if (p.getFailedNum() % 5 == 0 && !ProxyUtil.validateProxy(host)) {
            p.setReuseTimeInterval(this.reviveTime);
            this.logger.error("remove proxy >>>> " + host + ">>>>" + p.getFailedType() + " >>>> remain proxy >>>> " + this.proxyQueue.size());
            return;
        }
        try {
            this.proxyQueue.put(p);
        }
        catch (InterruptedException e) {
            this.logger.warn("proxyQueue return proxy error", (Throwable)e);
        }
    }

    public String allProxyStatus() {
        String re = "all proxy info >>>> \n";
        for (Map.Entry<String, Proxy> entry : this.allProxy.entrySet()) {
            re = re + entry.getValue().toString() + "\n";
        }
        return re;
    }

    public int getIdleNum() {
        return this.proxyQueue.size();
    }

    public int getReuseInterval() {
        return this.reuseInterval;
    }

    public void setReuseInterval(int reuseInterval) {
        this.reuseInterval = reuseInterval;
    }

    public static List<String[]> getProxyList() {
        ArrayList<String[]> proxyList = new ArrayList<String[]>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(new File("proxy.txt")));
            String line = "";
            while ((line = br.readLine()) != null) {
                proxyList.add(new String[]{line.split(":")[0], line.split(":")[1]});
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return proxyList;
    }

    public static void main(String[] args) throws IOException {
        ProxyPool proxyPool = new ProxyPool(ProxyPool.getProxyList());
        proxyPool.setReuseInterval(10000);
        while (true) {
            ArrayList<HttpHost> httphostList = new ArrayList<HttpHost>();
            System.in.read();
            int i = 0;
            while (proxyPool.getIdleNum() > 2) {
                HttpHost httphost = proxyPool.getProxy();
                httphostList.add(httphost);
                proxyPool.logger.info("borrow object>>>>" + i + ">>>>" + ((HttpHost)httphostList.get(i)).toString());
                ++i;
            }
            System.out.println(proxyPool.allProxyStatus());
            System.in.read();
            for (i = 0; i < httphostList.size(); ++i) {
                proxyPool.returnProxy((HttpHost)httphostList.get(i), 200);
                proxyPool.logger.info("return object>>>>" + i + ">>>>" + ((HttpHost)httphostList.get(i)).toString());
            }
            System.out.println(proxyPool.allProxyStatus());
            System.in.read();
        }
    }

    public void enable(boolean isEnable) {
        this.isEnable = isEnable;
    }

    public boolean isEnable() {
        return this.isEnable;
    }
}

