/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.AbstractDownloader;
import us.codecraft.webmagic.downloader.HttpClientGenerator;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.utils.UrlUtils;

@ThreadSafe
public class HttpClientDownloader
extends AbstractDownloader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, CloseableHttpClient> httpClients = new HashMap<String, CloseableHttpClient>();
    private HttpClientGenerator httpClientGenerator = new HttpClientGenerator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getHttpClient(Site site) {
        if (site == null) {
            return this.httpClientGenerator.getClient(null);
        }
        String domain = site.getDomain();
        CloseableHttpClient httpClient = this.httpClients.get(domain);
        if (httpClient == null) {
            HttpClientDownloader httpClientDownloader = this;
            synchronized (httpClientDownloader) {
                httpClient = this.httpClients.get(domain);
                if (httpClient == null) {
                    httpClient = this.httpClientGenerator.getClient(site);
                    this.httpClients.put(domain, httpClient);
                }
            }
        }
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page download(Request request, Task task) {
        HashSet acceptStatCode;
        Site site = null;
        if (task != null) {
            site = task.getSite();
        }
        String charset = null;
        Map<String, String> headers = null;
        if (site != null) {
            acceptStatCode = site.getAcceptStatCode();
            charset = site.getCharset();
            headers = site.getHeaders();
        } else {
            acceptStatCode = Sets.newHashSet((Object[])new Integer[]{200});
        }
        this.logger.info("downloading page {}", (Object)request.getUrl());
        CloseableHttpResponse httpResponse = null;
        int statusCode = 0;
        try {
            HttpUriRequest httpUriRequest = this.getHttpUriRequest(request, site, headers);
            httpResponse = this.getHttpClient(site).execute(httpUriRequest);
            statusCode = httpResponse.getStatusLine().getStatusCode();
            request.putExtra("statusCode", statusCode);
            if (this.statusAccept(acceptStatCode, statusCode)) {
                Page page = this.handleResponse(request, charset, (HttpResponse)httpResponse, task);
                this.onSuccess(request);
                Page page2 = page;
                return page2;
            }
            this.logger.warn("code error " + statusCode + "\t" + request.getUrl());
            Page page = null;
            return page;
        }
        catch (IOException e) {
            this.logger.warn("download page " + request.getUrl() + " error", (Throwable)e);
            if (site.getCycleRetryTimes() > 0) {
                Page page = this.addToCycleRetry(request, site);
                return page;
            }
            this.onError(request);
            Page page = null;
            return page;
        }
        finally {
            request.putExtra("statusCode", statusCode);
            try {
                if (httpResponse != null) {
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                }
            }
            catch (IOException e) {
                this.logger.warn("close response fail", (Throwable)e);
            }
        }
    }

    @Override
    public void setThread(int thread) {
        this.httpClientGenerator.setPoolSize(thread);
    }

    protected boolean statusAccept(Set<Integer> acceptStatCode, int statusCode) {
        return acceptStatCode.contains(statusCode);
    }

    protected HttpUriRequest getHttpUriRequest(Request request, Site site, Map<String, String> headers) {
        RequestBuilder requestBuilder = this.selectRequestMethod(request).setUri(request.getUrl());
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                requestBuilder.addHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(site.getTimeOut()).setSocketTimeout(site.getTimeOut()).setConnectTimeout(site.getTimeOut()).setCookieSpec("best-match");
        if (site.getHttpProxyPool().isEnable()) {
            HttpHost host = site.getHttpProxyFromPool();
            requestConfigBuilder.setProxy(host);
            request.putExtra("proxy", host);
        }
        requestBuilder.setConfig(requestConfigBuilder.build());
        return requestBuilder.build();
    }

    protected RequestBuilder selectRequestMethod(Request request) {
        String method = request.getMethod();
        if (method == null || method.equalsIgnoreCase("GET")) {
            return RequestBuilder.get();
        }
        if (method.equalsIgnoreCase("POST")) {
            RequestBuilder requestBuilder = RequestBuilder.post();
            NameValuePair[] nameValuePair = (NameValuePair[])request.getExtra("nameValuePair");
            if (nameValuePair.length > 0) {
                requestBuilder.addParameters(nameValuePair);
            }
            return requestBuilder;
        }
        if (method.equalsIgnoreCase("HEAD")) {
            return RequestBuilder.head();
        }
        if (method.equalsIgnoreCase("PUT")) {
            return RequestBuilder.put();
        }
        if (method.equalsIgnoreCase("DELETE")) {
            return RequestBuilder.delete();
        }
        if (method.equalsIgnoreCase("TRACE")) {
            return RequestBuilder.trace();
        }
        throw new IllegalArgumentException("Illegal HTTP Method " + method);
    }

    protected Page handleResponse(Request request, String charset, HttpResponse httpResponse, Task task) throws IOException {
        String content = this.getContent(charset, httpResponse);
        Page page = new Page();
        page.setRawText(content);
        page.setUrl(new PlainText(request.getUrl()));
        page.setRequest(request);
        page.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        return page;
    }

    protected String getContent(String charset, HttpResponse httpResponse) throws IOException {
        if (charset == null) {
            byte[] contentBytes = IOUtils.toByteArray((InputStream)httpResponse.getEntity().getContent());
            String htmlCharset = this.getHtmlCharset(httpResponse, contentBytes);
            if (htmlCharset != null) {
                return new String(contentBytes, htmlCharset);
            }
            this.logger.warn("Charset autodetect failed, use {} as charset. Please specify charset in Site.setCharset()", (Object)Charset.defaultCharset());
            return new String(contentBytes);
        }
        return IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)charset);
    }

    protected String getHtmlCharset(HttpResponse httpResponse, byte[] contentBytes) throws IOException {
        String value = httpResponse.getEntity().getContentType().getValue();
        String charset = UrlUtils.getCharset(value);
        if (StringUtils.isNotBlank((String)charset)) {
            this.logger.debug("Auto get charset: {}", (Object)charset);
            return charset;
        }
        Charset defaultCharset = Charset.defaultCharset();
        String content = new String(contentBytes, defaultCharset.name());
        if (StringUtils.isNotEmpty((String)content)) {
            Document document = Jsoup.parse((String)content);
            Elements links = document.select("meta");
            for (Element link : links) {
                String metaContent = link.attr("content");
                String metaCharset = link.attr("charset");
                if (metaContent.indexOf("charset") != -1) {
                    metaContent = metaContent.substring(metaContent.indexOf("charset"), metaContent.length());
                    charset = metaContent.split("=")[1];
                    break;
                }
                if (!StringUtils.isNotEmpty((String)metaCharset)) continue;
                charset = metaCharset;
                break;
            }
        }
        this.logger.debug("Auto get charset: {}", (Object)charset);
        return charset;
    }
}

