/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.http.annotation.ThreadSafe;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.LocalDuplicatedRemovedScheduler;
import us.codecraft.webmagic.utils.NumberUtils;

@ThreadSafe
public class PriorityScheduler
extends LocalDuplicatedRemovedScheduler {
    public static final int INITIAL_CAPACITY = 5;
    private BlockingQueue<Request> noPriorityQueue = new LinkedBlockingQueue<Request>();
    private PriorityBlockingQueue<Request> priorityQueuePlus = new PriorityBlockingQueue<Request>(5, new Comparator<Request>(){

        @Override
        public int compare(Request o1, Request o2) {
            return -NumberUtils.compareLong(o1.getPriority(), o2.getPriority());
        }
    });
    private PriorityBlockingQueue<Request> priorityQueueMinus = new PriorityBlockingQueue<Request>(5, new Comparator<Request>(){

        @Override
        public int compare(Request o1, Request o2) {
            return -NumberUtils.compareLong(o1.getPriority(), o2.getPriority());
        }
    });

    @Override
    public void pushWhenNoDuplicate(Request request, Task task) {
        if (request.getPriority() == 0L) {
            this.noPriorityQueue.add(request);
        } else if (request.getPriority() > 0L) {
            this.priorityQueuePlus.put(request);
        } else {
            this.priorityQueueMinus.put(request);
        }
    }

    @Override
    public synchronized Request poll(Task task) {
        Request poll = this.priorityQueuePlus.poll();
        if (poll != null) {
            return poll;
        }
        poll = (Request)this.noPriorityQueue.poll();
        if (poll != null) {
            return poll;
        }
        return this.priorityQueueMinus.poll();
    }
}

