/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.Scheduler;

public abstract class LocalDuplicatedRemovedScheduler
implements Scheduler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<String> urls = Sets.newSetFromMap(new ConcurrentHashMap());

    @Override
    public void push(Request request, Task task) {
        this.logger.debug("push to queue " + request.getUrl());
        if (request.getExtra("_cycle_tried_times") != null || this.urls.add(request.getUrl())) {
            this.pushWhenNoDuplicate(request, task);
        }
    }

    protected abstract void pushWhenNoDuplicate(Request var1, Task var2);
}

