/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import us.codecraft.webmagic.utils.Experimental;

public class Request
implements Serializable {
    private static final long serialVersionUID = 2062192774891352043L;
    public static final String CYCLE_TRIED_TIMES = "_cycle_tried_times";
    private String url;
    private Map<String, Object> extras;
    private long priority;

    public Request() {
    }

    public Request(String url) {
        this.url = url;
    }

    public long getPriority() {
        return this.priority;
    }

    @Experimental
    public Request setPriority(long priority) {
        this.priority = priority;
        return this;
    }

    public Object getExtra(String key) {
        if (this.extras == null) {
            return null;
        }
        return this.extras.get(key);
    }

    public Request putExtra(String key, Object value) {
        if (this.extras == null) {
            this.extras = new HashMap<String, Object>();
        }
        this.extras.put(key, value);
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return this.url.equals(request.url);
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public void setExtras(Map<String, Object> extras) {
        this.extras = extras;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return "Request{url='" + this.url + '\'' + ", extras=" + this.extras + ", priority=" + this.priority + '}';
    }
}

