/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.stream;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.iterable.StreamIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.StreamIterator;

public final class Streams {
    public static <T> Stream<T> toStream(Iterable<T> iterable) {
        if (iterable instanceof StreamIterable) {
            return ((StreamIterable)iterable).getStream();
        }
        return (Stream)StreamSupport.stream(iterable.spliterator(), false).onClose(() -> CloseableUtil.close((Object)iterable));
    }

    public static <T> Stream<T> toStream(T[] array) {
        return StreamSupport.stream(Spliterators.spliterator(array, 0), false);
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        if (iterator instanceof StreamIterator) {
            return ((StreamIterator)iterator).getStream();
        }
        Iterable iterable = () -> iterator;
        return (Stream)StreamSupport.stream(iterable.spliterator(), false).onClose(() -> CloseableUtil.close((Object)iterator));
    }

    public static <T> Stream<T> toParallelStream(Iterable<T> iterable) {
        if (iterable instanceof StreamIterable) {
            return (Stream)((StreamIterable)iterable).getStream().parallel();
        }
        return (Stream)StreamSupport.stream(iterable.spliterator(), true).onClose(() -> CloseableUtil.close((Object)iterable));
    }

    public static <T> Stream<T> toParallelStream(Iterator<T> iterator) {
        if (iterator instanceof StreamIterator) {
            return (Stream)((StreamIterator)iterator).getStream().parallel();
        }
        Iterable iterable = () -> iterator;
        return (Stream)StreamSupport.stream(iterable.spliterator(), true).onClose(() -> CloseableUtil.close((Object)iterator));
    }

    public static <T> Stream<T> toParallelStream(T[] array) {
        return StreamSupport.stream(Spliterators.spliterator(array, 0), true);
    }

    private Streams() {
    }
}

