/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.iterable.AlwaysValid;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.Validator;

public abstract class TransformOneToManyIterable<I, O>
implements CloseableIterable<O> {
    private final Iterable<? extends I> input;
    private final Validator<I> validator;
    private final boolean skipInvalid;
    private final boolean autoClose;

    public TransformOneToManyIterable(Iterable<? extends I> input) {
        this(input, new AlwaysValid(), false);
    }

    public TransformOneToManyIterable(Iterable<? extends I> input, Validator<I> validator) {
        this(input, validator, false);
    }

    public TransformOneToManyIterable(Iterable<? extends I> input, Validator<I> validator, boolean skipInvalid) {
        this(input, validator, skipInvalid, true);
    }

    public TransformOneToManyIterable(Iterable<? extends I> input, Validator<I> validator, boolean skipInvalid, boolean autoClose) {
        this.input = input;
        this.validator = validator;
        this.skipInvalid = skipInvalid;
        this.autoClose = autoClose;
    }

    @Override
    public void close() {
        CloseableUtil.close(this.input);
    }

    @Override
    public CloseableIterator<O> iterator() {
        return new CloseableIterator<O>(){
            private final Iterator<? extends I> inputItr;
            private Iterator<O> nextElements;
            private Boolean hasNext;
            {
                this.inputItr = TransformOneToManyIterable.this.input.iterator();
            }

            @Override
            public void close() {
                CloseableUtil.close(this.inputItr);
            }

            @Override
            public boolean hasNext() {
                if (null == this.hasNext) {
                    if (this.inputItr.hasNext()) {
                        Object possibleNext = this.inputItr.next();
                        if (TransformOneToManyIterable.this.validator.validate(possibleNext)) {
                            Iterable nextElementsIterable = TransformOneToManyIterable.this.transform(possibleNext);
                            if (null != nextElementsIterable) {
                                this.nextElements = nextElementsIterable.iterator();
                                if (this.nextElements.hasNext()) {
                                    this.hasNext = true;
                                } else {
                                    this.nextElements = null;
                                    this.hasNext();
                                }
                            } else {
                                this.hasNext();
                            }
                        } else if (TransformOneToManyIterable.this.skipInvalid) {
                            this.hasNext();
                        } else {
                            TransformOneToManyIterable.this.handleInvalidItem(possibleNext);
                        }
                    } else {
                        this.hasNext = false;
                        this.nextElements = null;
                    }
                }
                boolean hasNextResult = this._hasNext();
                if (TransformOneToManyIterable.this.autoClose && !hasNextResult) {
                    this.close();
                }
                return hasNextResult;
            }

            @Override
            public O next() {
                if (!this._hasNext() && !this.hasNext()) {
                    throw new NoSuchElementException("Reached the end of the iterator");
                }
                Object elementToReturn = this.nextElements.next();
                if (!this.nextElements.hasNext()) {
                    this.nextElements = null;
                    this.hasNext = null;
                }
                return elementToReturn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on a " + TransformOneToManyIterable.this.getIterableClass().getSimpleName() + " iterator");
            }

            private boolean _hasNext() {
                return Boolean.TRUE.equals(this.hasNext) && null != this.nextElements && this.nextElements.hasNext();
            }
        };
    }

    protected abstract Iterable<O> transform(I var1);

    protected void handleInvalidItem(I item) {
        String itemDescription = null != item ? item.toString() : "<unknown>";
        throw new IllegalArgumentException("Next " + itemDescription + " in iterable is not valid.");
    }

    private Class<? extends TransformOneToManyIterable> getIterableClass() {
        return this.getClass();
    }
}

