/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.iterable.AlwaysValid;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.Validator;

public abstract class TransformIterable<I, O>
implements CloseableIterable<O> {
    private final Iterable<? extends I> input;
    private final Validator<I> validator;
    private final boolean skipInvalid;
    private final boolean autoClose;

    public TransformIterable(Iterable<? extends I> input) {
        this(input, new AlwaysValid(), false);
    }

    public TransformIterable(Iterable<? extends I> input, Validator<I> validator) {
        this(input, validator, false);
    }

    public TransformIterable(Iterable<? extends I> input, Validator<I> validator, boolean skipInvalid) {
        this(input, validator, skipInvalid, true);
    }

    public TransformIterable(Iterable<? extends I> input, Validator<I> validator, boolean skipInvalid, boolean autoClose) {
        if (null == input) {
            throw new IllegalArgumentException("Input iterable is required");
        }
        this.input = input;
        this.validator = validator;
        this.skipInvalid = skipInvalid;
        this.autoClose = autoClose;
    }

    @Override
    public CloseableIterator<O> iterator() {
        return new CloseableIterator<O>(){
            private final Iterator<? extends I> inputItr;
            private O nextElement;
            private Boolean hasNext;
            {
                this.inputItr = TransformIterable.this.input.iterator();
            }

            @Override
            public void close() {
                CloseableUtil.close(this.inputItr);
            }

            @Override
            public boolean hasNext() {
                if (null == this.hasNext) {
                    while (this.inputItr.hasNext()) {
                        Object possibleNext = this.inputItr.next();
                        if (TransformIterable.this.validator.validate(possibleNext)) {
                            this.nextElement = TransformIterable.this.transform(possibleNext);
                            this.hasNext = true;
                            return Boolean.TRUE.equals(this.hasNext);
                        }
                        if (TransformIterable.this.skipInvalid) continue;
                        TransformIterable.this.handleInvalidItem(possibleNext);
                    }
                    this.hasNext = false;
                    this.nextElement = null;
                }
                boolean hasNextResult = Boolean.TRUE.equals(this.hasNext);
                if (TransformIterable.this.autoClose && !hasNextResult) {
                    this.close();
                }
                return hasNextResult;
            }

            @Override
            public O next() {
                if (null == this.hasNext && !this.hasNext()) {
                    throw new NoSuchElementException("Reached the end of the iterator");
                }
                Object elementToReturn = this.nextElement;
                this.nextElement = null;
                this.hasNext = null;
                return elementToReturn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on a " + TransformIterable.this.getIterableClass().getSimpleName() + " iterator");
            }
        };
    }

    @Override
    public void close() {
        CloseableUtil.close(this.input);
    }

    protected abstract O transform(I var1);

    protected void handleInvalidItem(I item) {
        String itemDescription = null != item ? item.toString() : "<unknown>";
        throw new IllegalArgumentException("Next " + itemDescription + " in iterable is not valid.");
    }

    protected Iterable<? extends I> getInput() {
        return this.input;
    }

    protected Validator<I> getValidator() {
        return this.validator;
    }

    private Class<? extends TransformIterable> getIterableClass() {
        return this.getClass();
    }
}

