/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.gov.gchq.gaffer.commonutil.exception.LimitExceededException;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.EmptyCloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.WrappedCloseableIterator;

public class LimitedCloseableIterator<T>
implements CloseableIterator<T> {
    private final CloseableIterator<T> iterator;
    private final Integer end;
    private int index = 0;
    private Boolean truncate = true;

    public LimitedCloseableIterator(Iterator<T> iterator, int start, Integer end) {
        this(iterator, start, end, (Boolean)true);
    }

    public LimitedCloseableIterator(Iterator<T> iterator, int start, Integer end, Boolean truncate) {
        this(new WrappedCloseableIterator<T>(iterator), start, end, truncate);
    }

    public LimitedCloseableIterator(CloseableIterator<T> iterator, int start, Integer end) {
        this(iterator, start, end, (Boolean)true);
    }

    public LimitedCloseableIterator(CloseableIterator<T> iterator, int start, Integer end, Boolean truncate) {
        if (null != end && start > end) {
            throw new IllegalArgumentException("start should be less than end");
        }
        this.iterator = null == iterator ? new EmptyCloseableIterator() : iterator;
        this.end = end;
        this.truncate = truncate;
        while (this.index < start && this.hasNext()) {
            this.next();
        }
    }

    @Override
    public void close() {
        this.iterator.close();
    }

    @Override
    public boolean hasNext() {
        boolean hasNext;
        boolean withinLimit;
        boolean bl = withinLimit = null == this.end || this.index < this.end;
        if (!withinLimit && !this.truncate.booleanValue() && this.iterator.hasNext()) {
            throw new LimitExceededException("Limit of " + this.end + " exceeded.");
        }
        boolean bl2 = hasNext = withinLimit && this.iterator.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        return (T)this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

