/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.EmptyClosableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.LimitedCloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.WrappedCloseableIterable;

public class LimitedCloseableIterable<T>
implements CloseableIterable<T> {
    private final CloseableIterable<T> iterable;
    private final int start;
    private final Integer end;
    private final Boolean truncate;

    public LimitedCloseableIterable(Iterable<T> iterable, int start, Integer end) {
        this(new WrappedCloseableIterable<T>(iterable), start, end);
    }

    public LimitedCloseableIterable(Iterable<T> iterable, int start, Integer end, Boolean truncate) {
        this(new WrappedCloseableIterable<T>(iterable), start, end, truncate);
    }

    public LimitedCloseableIterable(CloseableIterable<T> iterable, int start, Integer end) {
        this(iterable, start, end, (Boolean)true);
    }

    public LimitedCloseableIterable(CloseableIterable<T> iterable, int start, Integer end, Boolean truncate) {
        if (null != end && start > end) {
            throw new IllegalArgumentException("The start pointer must be less than the end pointer.");
        }
        this.iterable = null == iterable ? new EmptyClosableIterable() : iterable;
        this.start = start;
        this.end = end;
        this.truncate = truncate;
    }

    @JsonIgnore
    public int getStart() {
        return this.start;
    }

    @JsonIgnore
    public Integer getEnd() {
        return this.end;
    }

    @Override
    public void close() {
        this.iterable.close();
    }

    @Override
    public CloseableIterator<T> iterator() {
        return new LimitedCloseableIterator(this.iterable.iterator(), this.start, this.end, this.truncate);
    }
}

