/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;

public class ChainedIterable<T>
implements CloseableIterable<T> {
    private final Iterable<T>[] itrs;
    private final int n;

    public ChainedIterable(Iterable ... itrs) {
        if (null == itrs || 0 == itrs.length) {
            throw new IllegalArgumentException("At least 1 iterable is required.");
        }
        this.itrs = itrs;
        this.n = this.itrs.length;
    }

    @Override
    public void close() {
        for (Iterable<T> itr : this.itrs) {
            CloseableUtil.close(itr);
        }
    }

    @Override
    public CloseableIterator<T> iterator() {
        return new IteratorWrapper();
    }

    private class IteratorWrapper
    implements CloseableIterator<T> {
        private final Iterator<T>[] iterators;
        private int index;

        private IteratorWrapper() {
            this.iterators = new Iterator[ChainedIterable.this.itrs.length];
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return -1 != this.getNextIndex();
        }

        @Override
        public T next() {
            this.index = this.getNextIndex();
            if (-1 == this.index) {
                throw new NoSuchElementException();
            }
            return this.getIterator(this.index).next();
        }

        private int getNextIndex() {
            boolean hasNext = this.getIterator(this.index).hasNext();
            int nextIndex = this.index;
            while (!hasNext) {
                if (++nextIndex < ChainedIterable.this.n) {
                    hasNext = this.getIterator(nextIndex).hasNext();
                    continue;
                }
                nextIndex = -1;
                break;
            }
            return nextIndex;
        }

        @Override
        public void remove() {
            this.getIterator(this.index).remove();
        }

        private Iterator<T> getIterator(int i) {
            if (null == this.iterators[i]) {
                this.iterators[i] = ChainedIterable.this.itrs[i].iterator();
            }
            return this.iterators[i];
        }

        @Override
        public void close() {
            for (Iterator itr : this.iterators) {
                CloseableUtil.close(itr);
            }
            ChainedIterable.this.close();
        }
    }
}

