/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;

public abstract class BatchedIterable<T>
implements CloseableIterable<T> {
    private Iterable<T> batch;
    private Iterator<T> batchIterator;

    @Override
    public CloseableIterator<T> iterator() {
        this.closeBatch();
        return new BatchedIterator();
    }

    @Override
    public void close() {
        CloseableUtil.close(this.batchIterator);
        CloseableUtil.close(this.batch);
    }

    protected abstract Iterable<T> createBatch();

    private void closeBatch() {
        if (null != this.batchIterator) {
            CloseableUtil.close(this.batchIterator);
            this.batchIterator = null;
        }
        if (null != this.batch) {
            CloseableUtil.close(this.batch);
            this.batch = null;
        }
    }

    private final class BatchedIterator
    implements CloseableIterator<T> {
        private BatchedIterator() {
        }

        @Override
        public boolean hasNext() {
            if (null != BatchedIterable.this.batchIterator && BatchedIterable.this.batchIterator.hasNext()) {
                return true;
            }
            boolean hasNext = false;
            while (!hasNext) {
                BatchedIterable.this.closeBatch();
                BatchedIterable.this.batch = BatchedIterable.this.createBatch();
                if (null == BatchedIterable.this.batch) {
                    BatchedIterable.this.batchIterator = Collections.emptyIterator();
                    break;
                }
                BatchedIterable.this.batchIterator = BatchedIterable.this.batch.iterator();
                hasNext = BatchedIterable.this.batchIterator.hasNext();
            }
            return hasNext;
        }

        @Override
        public T next() {
            if (null == BatchedIterable.this.batchIterator) {
                throw new NoSuchElementException("Reached the end of the batch iterator");
            }
            return BatchedIterable.this.batchIterator.next();
        }

        @Override
        public void close() {
            BatchedIterable.this.closeBatch();
        }
    }
}

