/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorService.class);
    private static ScheduledExecutorService service;

    private ExecutorService() {
    }

    public static synchronized void initialise(int jobExecutorThreadCount) {
        if (service == null) {
            LOGGER.debug("Initialising ExecutorService with " + jobExecutorThreadCount + " threads");
            service = Executors.newScheduledThreadPool(jobExecutorThreadCount, runnable -> {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                return thread;
            });
        }
    }

    public static ScheduledExecutorService getService() {
        return service;
    }

    public static boolean isEnabled() {
        return null != service;
    }

    public static void shutdown() {
        if (null != service) {
            service.shutdown();
        }
        service = null;
    }
}

