/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DebugUtil {
    public static final String DEBUG = "gaffer.error-mode.debug";
    public static final String DEBUG_DEFAULT = String.valueOf(false);
    public static Boolean isDebug;
    private static final Logger LOGGER;

    private DebugUtil() {
    }

    public static boolean checkDebugMode() {
        if (null == isDebug) {
            DebugUtil.updateDebugMode();
        }
        return isDebug;
    }

    public static void updateDebugMode() {
        try {
            isDebug = Boolean.valueOf(System.getProperty(DEBUG, DEBUG_DEFAULT).trim());
            if (isDebug.booleanValue()) {
                LOGGER.debug("Debug has been enabled in SystemProperties");
            }
        }
        catch (Exception e) {
            LOGGER.error("Defaulting Debug flag. Could not assign from System Properties: {}", (Object)e.getMessage());
            isDebug = Boolean.valueOf(DEBUG_DEFAULT);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(DebugUtil.class);
    }
}

