/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import java.security.InvalidParameterException;
import java.util.Arrays;

public final class ByteArrayEscapeUtils {
    public static final byte DELIMITER = 0;
    public static final byte DELIMITER_PLUS_ONE = 1;
    private static final byte ESCAPE_CHAR = 1;
    private static final byte REPLACEMENT_CHAR = 2;

    private ByteArrayEscapeUtils() {
    }

    public static byte[] escape(byte[] bytes, byte ... appendAfterEscaping) {
        byte[] temp = new byte[2 * bytes.length + (null == appendAfterEscaping ? 0 : appendAfterEscaping.length)];
        int currentPosition = ByteArrayEscapeUtils.escape(bytes, temp, 0);
        if (null != appendAfterEscaping) {
            for (byte b : appendAfterEscaping) {
                temp[currentPosition++] = b;
            }
        }
        return Arrays.copyOfRange(temp, 0, currentPosition);
    }

    private static int escape(byte[] bytes, byte[] temp, int position) {
        int currentPosition = position;
        for (byte b : bytes) {
            if (1 == b) {
                temp[currentPosition++] = 1;
                temp[currentPosition++] = 2;
                continue;
            }
            if (0 == b) {
                temp[currentPosition++] = 1;
                temp[currentPosition++] = 1;
                continue;
            }
            temp[currentPosition++] = b;
        }
        return currentPosition;
    }

    public static byte[] unEscape(byte[] bytes) {
        return ByteArrayEscapeUtils.unEscapeByLength(bytes, 0, bytes.length);
    }

    public static byte[] unEscape(byte[] allBytes, int start, int end) {
        return ByteArrayEscapeUtils.unEscapeByPosition(allBytes, start, end);
    }

    public static byte[] unEscapeByPosition(byte[] allBytes, int start, int end) {
        return ByteArrayEscapeUtils.unEscapeByLength(allBytes, start, end - start);
    }

    public static byte[] unEscapeByLength(byte[] allBytes, int offset, int length) {
        if (allBytes.length < offset + length) {
            throw new InvalidParameterException(String.format("unEscape parameters larger than allByte.length:%d, offset:%d, length:%d", allBytes.length, offset, length));
        }
        byte[] temp = new byte[length];
        int currentPosition = 0;
        boolean isEscaped = false;
        for (int i = offset; i < allBytes.length && i < offset + length; ++i) {
            byte b = allBytes[i];
            if (isEscaped) {
                temp[currentPosition++] = 2 == b ? (byte)1 : (1 == b ? (byte)0 : b);
                isEscaped = false;
                continue;
            }
            if (1 == b) {
                isEscaped = true;
                continue;
            }
            temp[currentPosition++] = b;
        }
        byte[] unEscaped = new byte[currentPosition];
        System.arraycopy(temp, 0, unEscaped, 0, currentPosition);
        return unEscaped;
    }
}

