/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.status;

import uk.co.real_logic.agrona.concurrent.CountersManager;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.agrona.status.PositionIndicator;

public class BufferPositionIndicator
implements PositionIndicator {
    private final UnsafeBuffer buffer;
    private final int counterId;
    private final CountersManager countersManager;
    private final int offset;

    public BufferPositionIndicator(UnsafeBuffer buffer, int counterId) {
        this(buffer, counterId, null);
    }

    public BufferPositionIndicator(UnsafeBuffer buffer, int counterId, CountersManager countersManager) {
        this.buffer = buffer;
        this.counterId = counterId;
        this.countersManager = countersManager;
        this.offset = CountersManager.counterOffset(counterId);
    }

    @Override
    public long position() {
        return this.buffer.getLongVolatile(this.offset);
    }

    @Override
    public void close() {
        this.countersManager.free(this.counterId);
    }
}

