/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent.broadcast;

import uk.co.real_logic.agrona.MutableDirectBuffer;
import uk.co.real_logic.agrona.concurrent.MessageHandler;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.agrona.concurrent.broadcast.BroadcastReceiver;

public class CopyBroadcastReceiver {
    private static final int SCRATCH_BUFFER_SIZE = 4096;
    private final BroadcastReceiver receiver;
    private final MutableDirectBuffer scratchBuffer;

    public CopyBroadcastReceiver(BroadcastReceiver receiver) {
        this.receiver = receiver;
        this.scratchBuffer = new UnsafeBuffer(new byte[4096]);
        while (receiver.receiveNext()) {
        }
    }

    public int receive(MessageHandler handler) {
        int messagesReceived = 0;
        BroadcastReceiver receiver = this.receiver;
        long lastSeenLappedCount = receiver.lappedCount();
        if (receiver.receiveNext()) {
            int capacity;
            if (lastSeenLappedCount != receiver.lappedCount()) {
                throw new IllegalStateException("Unable to keep up with broadcast buffer");
            }
            int length = receiver.length();
            if (length > (capacity = this.scratchBuffer.capacity())) {
                throw new IllegalStateException(String.format("Buffer required size %d but only has %d", length, capacity));
            }
            int msgTypeId = receiver.typeId();
            this.scratchBuffer.putBytes(0, receiver.buffer(), receiver.offset(), length);
            if (!receiver.validate()) {
                throw new IllegalStateException("Unable to keep up with broadcast buffer");
            }
            handler.onMessage(msgTypeId, this.scratchBuffer, 0, length);
            messagesReceived = 1;
        }
        return messagesReceived;
    }
}

