/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent;

import java.nio.ByteOrder;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import uk.co.real_logic.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.agrona.concurrent.AtomicCounter;

public class CountersManager {
    public static final int LABEL_SIZE = 1024;
    public static final int COUNTER_SIZE = 64;
    public static final int UNREGISTERED_LABEL_SIZE = -1;
    private final AtomicBuffer labelsBuffer;
    private final AtomicBuffer countersBuffer;
    private final Deque<Integer> freeList = new LinkedList<Integer>();
    private int idHighWaterMark = -1;

    public CountersManager(AtomicBuffer labelsBuffer, AtomicBuffer countersBuffer) {
        this.labelsBuffer = labelsBuffer;
        this.countersBuffer = countersBuffer;
    }

    public int allocate(String label) {
        int counterId = this.counterId();
        int labelsOffset = this.labelOffset(counterId);
        if (CountersManager.counterOffset(counterId) + 64 > this.countersBuffer.capacity()) {
            throw new IllegalArgumentException("Unable to allocated counter, counter buffer is full");
        }
        if (labelsOffset + 1024 > this.labelsBuffer.capacity()) {
            throw new IllegalArgumentException("Unable to allocate counter, labels buffer is full");
        }
        this.labelsBuffer.putStringUtf8(labelsOffset, label, ByteOrder.nativeOrder(), 1020);
        return counterId;
    }

    public AtomicCounter newCounter(String label) {
        return new AtomicCounter(this.countersBuffer, this.allocate(label), this);
    }

    public void free(int counterId) {
        this.labelsBuffer.putInt(this.labelOffset(counterId), -1);
        this.countersBuffer.putLongOrdered(CountersManager.counterOffset(counterId), 0L);
        this.freeList.push(counterId);
    }

    public static int counterOffset(int id) {
        return id * 64;
    }

    public void forEach(BiConsumer<Integer, String> consumer) {
        int size;
        int labelsOffset = 0;
        int id = 0;
        while ((size = this.labelsBuffer.getInt(labelsOffset)) != 0) {
            if (size != -1) {
                String label = this.labelsBuffer.getStringUtf8(labelsOffset, ByteOrder.nativeOrder());
                consumer.accept(id, label);
            }
            labelsOffset += 1024;
            ++id;
        }
    }

    public void setCounterValue(int counterId, long value) {
        this.countersBuffer.putLongOrdered(CountersManager.counterOffset(counterId), value);
    }

    private int labelOffset(int counterId) {
        return counterId * 1024;
    }

    private int counterId() {
        if (this.freeList.isEmpty()) {
            return ++this.idHighWaterMark;
        }
        return this.freeList.pop();
    }
}

