/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.torque.engine.database.model.TypeMap;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TorqueJDBCTransformTask
extends Task {
    protected String xmlSchema;
    protected String dbUrl;
    protected String dbDriver;
    protected String dbUser;
    protected String dbPassword;
    protected String dbSchema;
    protected DocumentImpl doc;
    protected Element databaseNode;
    protected Hashtable primaryKeys;
    protected Hashtable columnTableMap;
    protected boolean sameJavaName;
    private XMLSerializer xmlSerializer;

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public void setDbUrl(String v) {
        this.dbUrl = v;
    }

    public void setDbDriver(String v) {
        this.dbDriver = v;
    }

    public void setDbUser(String v) {
        this.dbUser = v;
    }

    public void setDbPassword(String v) {
        this.dbPassword = v;
    }

    public void setOutputFile(String v) {
        this.xmlSchema = v;
    }

    public void setSameJavaName(boolean v) {
        this.sameJavaName = v;
    }

    public boolean isSameJavaName() {
        return this.sameJavaName;
    }

    public void execute() throws BuildException {
        this.log("Torque - JDBCToXMLSchema starting");
        this.log("Your DB settings are:");
        this.log("driver : " + this.dbDriver);
        this.log("URL : " + this.dbUrl);
        this.log("user : " + this.dbUser);
        this.log("schema : " + this.dbSchema);
        DocumentTypeImpl docType = new DocumentTypeImpl(null, "database", null, "http://db.apache.org/torque/dtd/database_3_3.dtd");
        this.doc = new DocumentImpl((DocumentType)docType);
        this.doc.appendChild((Node)this.doc.createComment(" Autogenerated by JDBCToXMLSchema! "));
        try {
            this.generateXML();
            this.log(this.xmlSchema);
            this.xmlSerializer = new XMLSerializer((Writer)new PrintWriter(new FileOutputStream(this.xmlSchema)), new OutputFormat("xml", null, true));
            this.xmlSerializer.serialize((Document)this.doc);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        this.log("Torque - JDBCToXMLSchema finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generateXML() throws Exception {
        Class.forName(this.dbDriver);
        this.log("DB driver sucessfuly instantiated");
        Connection con = null;
        try {
            String curTable;
            int i;
            con = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
            this.log("DB connection established");
            DatabaseMetaData dbMetaData = con.getMetaData();
            List tableList = this.getTableNames(dbMetaData);
            this.databaseNode = this.doc.createElement("database");
            this.databaseNode.setAttribute("name", this.dbUser);
            this.columnTableMap = new Hashtable();
            this.log("Building column/table map...");
            for (i = 0; i < tableList.size(); ++i) {
                curTable = (String)tableList.get(i);
                List columns = this.getColumns(dbMetaData, curTable);
                for (int j = 0; j < columns.size(); ++j) {
                    List col = (List)columns.get(j);
                    String name = (String)col.get(0);
                    this.columnTableMap.put(name, curTable);
                }
            }
            for (i = 0; i < tableList.size(); ++i) {
                curTable = (String)tableList.get(i);
                this.log("Processing table: " + curTable);
                Element table = this.doc.createElement("table");
                table.setAttribute("name", curTable);
                if (this.isSameJavaName()) {
                    table.setAttribute("javaName", curTable);
                }
                List columns = this.getColumns(dbMetaData, curTable);
                List primKeys = this.getPrimaryKeys(dbMetaData, curTable);
                Collection forgnKeys = this.getForeignKeys(dbMetaData, curTable);
                this.primaryKeys = new Hashtable();
                for (int k = 0; k < primKeys.size(); ++k) {
                    String curPrimaryKey = (String)primKeys.get(k);
                    this.primaryKeys.put(curPrimaryKey, curPrimaryKey);
                }
                for (int j = 0; j < columns.size(); ++j) {
                    List col = (List)columns.get(j);
                    String name = (String)col.get(0);
                    Integer type = (Integer)col.get(1);
                    int size = (Integer)col.get(2);
                    int scale = (Integer)col.get(5);
                    Integer nullType = (Integer)col.get(3);
                    String defValue = (String)col.get(4);
                    Element column = this.doc.createElement("column");
                    column.setAttribute("name", name);
                    if (this.isSameJavaName()) {
                        column.setAttribute("javaName", name);
                    }
                    column.setAttribute("type", TypeMap.getTorqueType(type).getName());
                    if (size > 0 && (type == 1 || type == 12 || type == -1 || type == 3 || type == 2)) {
                        column.setAttribute("size", String.valueOf(size));
                    }
                    if (scale > 0 && (type == 3 || type == 2)) {
                        column.setAttribute("scale", String.valueOf(scale));
                    }
                    if (nullType == 0) {
                        column.setAttribute("required", "true");
                    }
                    if (this.primaryKeys.containsKey(name)) {
                        column.setAttribute("primaryKey", "true");
                    }
                    if (StringUtils.isNotEmpty((String)defValue)) {
                        if (defValue.startsWith("(") && defValue.endsWith(")")) {
                            defValue = defValue.substring(1, defValue.length() - 1);
                        }
                        if (defValue.startsWith("'") && defValue.endsWith("'")) {
                            defValue = defValue.substring(1, defValue.length() - 1);
                        }
                        column.setAttribute("default", defValue);
                    }
                    table.appendChild(column);
                }
                Iterator l = forgnKeys.iterator();
                while (l.hasNext()) {
                    Object[] forKey = (Object[])l.next();
                    String foreignKeyTable = (String)forKey[0];
                    List refs = (List)forKey[1];
                    Element fk = this.doc.createElement("foreign-key");
                    fk.setAttribute("foreignTable", foreignKeyTable);
                    for (int m = 0; m < refs.size(); ++m) {
                        Element ref = this.doc.createElement("reference");
                        String[] refData = (String[])refs.get(m);
                        ref.setAttribute("local", refData[0]);
                        ref.setAttribute("foreign", refData[1]);
                        fk.appendChild(ref);
                    }
                    table.appendChild(fk);
                }
                this.databaseNode.appendChild(table);
            }
            this.doc.appendChild((Node)this.databaseNode);
            Object var20_23 = null;
            if (con == null) return;
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            if (con == null) throw throwable;
            con.close();
            con = null;
            throw throwable;
        }
        con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTableNames(DatabaseMetaData dbMeta) throws SQLException {
        this.log("Getting table list...");
        ArrayList<String> tables = new ArrayList<String>();
        ResultSet tableNames = null;
        String[] types = new String[]{"TABLE", "VIEW"};
        try {
            tableNames = dbMeta.getTables(null, this.dbSchema, "%", types);
            while (tableNames.next()) {
                String name = tableNames.getString(3);
                tables.add(name);
            }
        }
        finally {
            if (tableNames != null) {
                tableNames.close();
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getColumns(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        ArrayList columns = new ArrayList();
        ResultSet columnSet = null;
        try {
            columnSet = dbMeta.getColumns(null, this.dbSchema, tableName, null);
            while (columnSet.next()) {
                String name = columnSet.getString(4);
                Integer sqlType = new Integer(columnSet.getString(5));
                Integer size = new Integer(columnSet.getInt(7));
                Integer decimalDigits = new Integer(columnSet.getInt(9));
                Integer nullType = new Integer(columnSet.getInt(11));
                String defValue = columnSet.getString(13);
                ArrayList<Object> col = new ArrayList<Object>(6);
                col.add(name);
                col.add(sqlType);
                col.add(size);
                col.add(nullType);
                col.add(defValue);
                col.add(decimalDigits);
                columns.add(col);
            }
        }
        finally {
            if (columnSet != null) {
                columnSet.close();
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPrimaryKeys(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        ArrayList<String> pk = new ArrayList<String>();
        ResultSet parts = null;
        try {
            parts = dbMeta.getPrimaryKeys(null, this.dbSchema, tableName);
            while (parts.next()) {
                pk.add(parts.getString(4));
            }
        }
        finally {
            if (parts != null) {
                parts.close();
            }
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getForeignKeys(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        Hashtable<String, Object[]> fks = new Hashtable<String, Object[]>();
        ResultSet foreignKeys = null;
        try {
            foreignKeys = dbMeta.getImportedKeys(null, this.dbSchema, tableName);
            while (foreignKeys.next()) {
                ArrayList<String[]> refs;
                Object[] fk;
                String refTableName = foreignKeys.getString(3);
                String fkName = foreignKeys.getString(12);
                if (fkName == null) {
                    fkName = refTableName;
                }
                if ((fk = (Object[])fks.get(fkName)) == null) {
                    refs = new ArrayList<String[]>();
                    fk = new Object[]{refTableName, refs};
                    fks.put(fkName, fk);
                } else {
                    refs = (ArrayList<String[]>)fk[1];
                }
                String[] ref = new String[]{foreignKeys.getString(8), foreignKeys.getString(4)};
                refs.add(ref);
            }
        }
        catch (SQLException e) {
            this.log("WARN: Could not read foreign keys for Table " + tableName + " : " + e.getMessage(), 1);
        }
        finally {
            if (foreignKeys != null) {
                foreignKeys.close();
            }
        }
        return fks.values();
    }
}

