/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.texen.Generator;
import org.apache.texen.ant.TexenTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.transform.XmlToAppData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

public class TorqueDataModelTask
extends TexenTask {
    protected String xmlFile;
    protected List filesets = new ArrayList();
    protected List dataModels = new ArrayList();
    protected Context context;
    protected Hashtable dataModelDbMap;
    protected Hashtable databaseNames;
    protected String sqldbmap;
    private String targetDatabase;
    private String targetPackage;
    private static final String ERR_MSG_FRAGMENT = ". For more information consult the velocity log, or invoke ant with the -debug flag.";

    public void setSqlDbMap(String sqldbmap) {
        this.sqldbmap = this.getProject().resolveFile(sqldbmap).toString();
    }

    public String getSqlDbMap() {
        return this.sqldbmap;
    }

    public List getDataModels() {
        return this.dataModels;
    }

    public Hashtable getDataModelDbMap() {
        return this.dataModelDbMap;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String xmlFile) {
        this.xmlFile = this.getProject().resolveFile(xmlFile).toString();
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    public void setTargetDatabase(String v) {
        this.targetDatabase = v;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public void setTargetPackage(String v) {
        this.targetPackage = v;
    }

    public Context initControlContext() throws Exception {
        if (this.xmlFile == null && this.filesets.isEmpty()) {
            throw new BuildException("You must specify an XML schema or fileset of XML schemas!");
        }
        try {
            XmlToAppData xmlParser;
            if (this.xmlFile != null) {
                xmlParser = new XmlToAppData(this.getTargetDatabase(), this.getTargetPackage());
                Database ad = xmlParser.parseFile(this.xmlFile);
                ad.setFileName(this.grokName(this.xmlFile));
                this.dataModels.add(ad);
            } else {
                for (int i = 0; i < this.filesets.size(); ++i) {
                    FileSet fs = (FileSet)this.filesets.get(i);
                    DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                    File srcDir = fs.getDir(this.getProject());
                    String[] dataModelFiles = ds.getIncludedFiles();
                    for (int j = 0; j < dataModelFiles.length; ++j) {
                        File f = new File(srcDir, dataModelFiles[j]);
                        xmlParser = new XmlToAppData(this.getTargetDatabase(), this.getTargetPackage());
                        Database ad = xmlParser.parseFile(f.toString());
                        ad.setFileName(this.grokName(f.toString()));
                        this.dataModels.add(ad);
                    }
                }
            }
            Iterator i = this.dataModels.iterator();
            this.databaseNames = new Hashtable();
            this.dataModelDbMap = new Hashtable();
            while (i.hasNext()) {
                Database database = (Database)i.next();
                this.databaseNames.put(database.getName(), database.getName());
                this.dataModelDbMap.put(database.getFileName(), database.getName());
            }
        }
        catch (EngineException ee) {
            throw new BuildException((Throwable)((Object)ee));
        }
        this.context = new VelocityContext();
        this.context.put("dataModels", (Object)this.dataModels);
        this.context.put("databaseNames", (Object)this.databaseNames);
        this.context.put("targetDatabase", (Object)this.targetDatabase);
        this.context.put("targetPackage", (Object)this.targetPackage);
        return this.context;
    }

    protected void populateInitialContext(Context context) throws Exception {
        super.populateInitialContext(context);
        context.put("now", (Object)new Date());
    }

    private String grokName(String xmlFile) {
        String name = "data-model";
        int i = xmlFile.lastIndexOf(System.getProperty("file.separator"));
        if (i != -1) {
            int j = xmlFile.lastIndexOf(46);
            name = ++i < j ? xmlFile.substring(i, j) : xmlFile.substring(i);
        }
        return name;
    }

    public void setContextProperties(String file) {
        super.setContextProperties(file);
        Hashtable env = super.getProject().getProperties();
        Iterator i = env.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("torque.")) continue;
            String newKey = key.substring("torque.".length());
            int j = newKey.indexOf(".");
            while (j != -1) {
                newKey = newKey.substring(0, j) + StringUtils.capitalize((String)newKey.substring(j + 1));
                j = newKey.indexOf(".");
            }
            this.contextProperties.setProperty(newKey, entry.getValue());
        }
    }

    public void execute() throws BuildException {
        if (this.templatePath == null && !this.useClasspath) {
            throw new BuildException("The template path needs to be defined if you are not using the classpath for locating templates!");
        }
        if (this.controlTemplate == null) {
            throw new BuildException("The control template needs to be defined!");
        }
        if (this.outputDirectory == null) {
            throw new BuildException("The output directory needs to be defined!");
        }
        if (this.outputFile == null) {
            throw new BuildException("The output file needs to be defined!");
        }
        VelocityEngine ve = new VelocityEngine();
        try {
            File file;
            if (this.templatePath != null) {
                this.log("Using templatePath: " + this.templatePath, 3);
                ve.setProperty("torquefile.resource.loader.path", (Object)this.templatePath);
                ve.addProperty("resource.loader", (Object)"torquefile");
                ve.setProperty("torquefile.resource.loader.instance", (Object)new TorqueFileResourceLoader(this));
            }
            if (this.useClasspath) {
                this.log("Using classpath");
                ve.addProperty("resource.loader", (Object)"classpath");
                ve.setProperty("classpath.resource.loader.instance", (Object)new TorqueClasspathResourceLoader(this));
                ve.setProperty("classpath.resource.loader.cache", (Object)"false");
                ve.setProperty("classpath.resource.loader.modificationCheckInterval", (Object)"2");
            }
            ve.init();
            Generator generator = Generator.getInstance();
            generator.setVelocityEngine(ve);
            generator.setOutputPath(this.outputDirectory);
            generator.setInputEncoding(this.inputEncoding);
            generator.setOutputEncoding(this.outputEncoding);
            if (this.templatePath != null) {
                generator.setTemplatePath(this.templatePath);
            }
            if (!(file = new File(this.outputDirectory)).exists()) {
                file.mkdirs();
            }
            String path = this.outputDirectory + File.separator + this.outputFile;
            this.log("Generating to file " + path, 2);
            Writer writer = generator.getWriter(path, this.outputEncoding);
            Context c = this.initControlContext();
            this.populateInitialContext(c);
            if (this.contextProperties != null) {
                Iterator i = this.contextProperties.getKeys();
                while (i.hasNext()) {
                    String property = (String)i.next();
                    String value = this.contextProperties.getString(property);
                    try {
                        c.put(property, (Object)new Integer(value));
                    }
                    catch (NumberFormatException nfe) {
                        String booleanString = this.contextProperties.testBoolean(value);
                        if (booleanString != null) {
                            c.put(property, (Object)new Boolean(booleanString));
                            continue;
                        }
                        if (property.endsWith("file.contents")) {
                            value = org.apache.velocity.util.StringUtils.fileContentsToString((String)this.project.resolveFile(value).getCanonicalPath());
                            property = property.substring(0, property.indexOf("file.contents") - 1);
                        }
                        c.put(property, (Object)value);
                    }
                }
            }
            writer.write(generator.parse(this.controlTemplate, c));
            writer.flush();
            writer.close();
            generator.shutdown();
            this.cleanup();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (MethodInvocationException e) {
            throw new BuildException("Exception thrown by '" + e.getReferenceName() + "." + e.getMethodName() + "'" + ERR_MSG_FRAGMENT, e.getWrappedThrowable());
        }
        catch (ParseErrorException e) {
            throw new BuildException("Velocity syntax error. For more information consult the velocity log, or invoke ant with the -debug flag.", (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            throw new BuildException("Resource not found. For more information consult the velocity log, or invoke ant with the -debug flag.", (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException("Generation failed. For more information consult the velocity log, or invoke ant with the -debug flag.", (Throwable)e);
        }
    }

    protected InputStream filter(InputStream resource) throws IOException {
        InputStreamReader streamReader = this.inputEncoding != null ? new InputStreamReader(resource, this.inputEncoding) : new InputStreamReader(resource);
        LineNumberReader lineNumberReader = new LineNumberReader(streamReader);
        String line = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = null;
        ps = this.inputEncoding != null ? new PrintStream((OutputStream)baos, true, this.inputEncoding) : new PrintStream(baos, true);
        while ((line = lineNumberReader.readLine()) != null) {
            line = line.replaceAll("^\\s*#", "#");
            line = line.replaceAll("\t", "    ");
            ps.println(line);
        }
        ps.flush();
        ps.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static class TorqueFileResourceLoader
    extends FileResourceLoader {
        private TorqueDataModelTask task;

        public TorqueFileResourceLoader(TorqueDataModelTask task) {
            this.task = task;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized InputStream getResourceStream(String name) throws ResourceNotFoundException {
            InputStream inputStream;
            InputStream source = null;
            try {
                try {
                    source = super.getResourceStream(name);
                    inputStream = this.task.filter(source);
                    Object var5_5 = null;
                    if (source == null) return inputStream;
                }
                catch (IOException uee) {
                    this.task.log(uee.getMessage());
                    throw new ResourceNotFoundException(uee.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (source == null) throw throwable;
                try {
                    source.close();
                    throw throwable;
                }
                catch (IOException e) {
                    this.task.log(e.getMessage());
                    throw throwable;
                }
            }
            try {}
            catch (IOException e) {
                this.task.log(e.getMessage());
                return inputStream;
            }
            source.close();
            return inputStream;
        }
    }

    public static class TorqueClasspathResourceLoader
    extends ClasspathResourceLoader {
        private TorqueDataModelTask task;

        public TorqueClasspathResourceLoader(TorqueDataModelTask task) {
            this.task = task;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized InputStream getResourceStream(String name) throws ResourceNotFoundException {
            InputStream inputStream;
            InputStream source = null;
            try {
                try {
                    source = super.getResourceStream(name);
                    inputStream = this.task.filter(source);
                    Object var5_5 = null;
                    if (source == null) return inputStream;
                }
                catch (IOException uee) {
                    this.task.log(uee.getMessage());
                    throw new ResourceNotFoundException(uee.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (source == null) throw throwable;
                try {
                    source.close();
                    throw throwable;
                }
                catch (IOException e) {
                    this.task.log(e.getMessage());
                    throw throwable;
                }
            }
            try {}
            catch (IOException e) {
                this.task.log(e.getMessage());
                return inputStream;
            }
            source.close();
            return inputStream;
        }
    }
}

