/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.platform;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.platform.Platform;
import org.apache.torque.engine.platform.PlatformDefaultImpl;

public class PlatformFactory {
    private static HashMap platforms = new HashMap();
    private static Log log = LogFactory.getLog((Class)PlatformFactory.class);

    public static Platform getPlatformFor(String dbms) {
        Platform result = null;
        String platformName = null;
        result = (Platform)PlatformFactory.getPlatforms().get(dbms);
        if (result == null) {
            try {
                platformName = PlatformFactory.getClassnameFor(dbms);
                Class<?> platformClass = Class.forName(platformName);
                result = (Platform)platformClass.newInstance();
            }
            catch (Throwable t) {
                log.warn((Object)("problems with platform " + platformName + ": " + t.getMessage()));
                log.warn((Object)"Torque will use PlatformDefaultImpl instead");
                result = new PlatformDefaultImpl();
            }
            PlatformFactory.getPlatforms().put(dbms, result);
        }
        return result;
    }

    private static String getClassnameFor(String platform) {
        String pf = "Default";
        if (platform != null) {
            pf = platform;
        }
        return "org.apache.torque.engine.platform.Platform" + pf.substring(0, 1).toUpperCase() + pf.substring(1) + "Impl";
    }

    private static HashMap getPlatforms() {
        return platforms;
    }
}

