/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.transform;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Domain;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Index;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.Unique;
import org.apache.torque.engine.database.transform.DTDResolver;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToAppData
extends DefaultHandler {
    private static Log log = LogFactory.getLog((Class)XmlToAppData.class);
    private Database database;
    private Table currTable;
    private Column currColumn;
    private ForeignKey currFK;
    private Index currIndex;
    private Unique currUnique;
    private boolean firstPass;
    private boolean isExternalSchema;
    private String currentPackage;
    private String currentXmlFile;
    private String defaultPackage;
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private Vector alreadyReadFiles;
    private Stack parsingStack = new Stack();

    public XmlToAppData(String databaseType) {
        this.database = new Database(databaseType);
        this.firstPass = true;
    }

    public XmlToAppData(String databaseType, String defaultPackage) {
        this.database = new Database(databaseType);
        this.defaultPackage = defaultPackage;
        this.firstPass = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database parseFile(String xmlFile) throws EngineException {
        try {
            if (!this.firstPass) {
                throw new Error("No more double pass");
            }
            if (this.alreadyReadFiles != null && this.alreadyReadFiles.contains(xmlFile)) {
                return this.database;
            }
            if (this.alreadyReadFiles == null) {
                this.alreadyReadFiles = new Vector(3, 1);
            }
            this.alreadyReadFiles.add(xmlFile);
            this.currentXmlFile = xmlFile;
            SAXParser parser = saxFactory.newSAXParser();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(xmlFile);
            }
            catch (FileNotFoundException fnfe) {
                throw new FileNotFoundException(new File(xmlFile).getAbsolutePath());
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                log.info((Object)("Parsing file: '" + new File(xmlFile).getName() + "'"));
                InputSource is = new InputSource(bufferedInputStream);
                parser.parse(is, (DefaultHandler)this);
            }
            finally {
                bufferedInputStream.close();
            }
        }
        catch (SAXParseException e) {
            throw new EngineException("Sax error on line " + e.getLineNumber() + " column " + e.getColumnNumber() + " : " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new EngineException(e);
        }
        if (!this.isExternalSchema) {
            this.firstPass = false;
        }
        this.database.doFinalInitialization();
        return this.database;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return new DTDResolver().resolveEntity(publicId, systemId);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        try {
            if (rawName.equals("database")) {
                if (this.isExternalSchema) {
                    this.currentPackage = attributes.getValue("package");
                    if (this.currentPackage == null) {
                        this.currentPackage = this.defaultPackage;
                    }
                } else {
                    this.database.loadFromXML(attributes);
                    if (this.database.getPackage() == null) {
                        this.database.setPackage(this.defaultPackage);
                    }
                }
            } else if (rawName.equals("external-schema")) {
                String xmlFile = attributes.getValue("filename");
                if (xmlFile.charAt(0) != '/') {
                    File f = new File(this.currentXmlFile);
                    xmlFile = new File(f.getParent(), xmlFile).getPath();
                }
                ParseStackElement.pushState(this);
                this.isExternalSchema = true;
                this.parseFile(xmlFile);
                ParseStackElement.popState(this);
            } else if (rawName.equals("domain")) {
                Domain domain = new Domain();
                domain.loadFromXML(attributes, this.database.getPlatform());
                this.database.addDomain(domain);
            } else if (rawName.equals("table")) {
                this.currTable = this.database.addTable(attributes);
                if (this.isExternalSchema) {
                    this.currTable.setForReferenceOnly(true);
                    this.currTable.setPackage(this.currentPackage);
                }
            } else if (rawName.equals("column")) {
                this.currColumn = this.currTable.addColumn(attributes);
            } else if (rawName.equals("inheritance")) {
                this.currColumn.addInheritance(attributes);
            } else if (rawName.equals("foreign-key")) {
                this.currFK = this.currTable.addForeignKey(attributes);
            } else if (rawName.equals("reference")) {
                this.currFK.addReference(attributes);
            } else if (rawName.equals("index")) {
                this.currIndex = this.currTable.addIndex(attributes);
            } else if (rawName.equals("index-column")) {
                this.currIndex.addColumn(attributes);
            } else if (rawName.equals("unique")) {
                this.currUnique = this.currTable.addUnique(attributes);
            } else if (rawName.equals("unique-column")) {
                this.currUnique.addColumn(attributes);
            } else if (rawName.equals("id-method-parameter")) {
                this.currTable.addIdMethodParameter(attributes);
            } else if (rawName.equals("option")) {
                this.setOption(attributes);
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("endElement(" + uri + ", " + localName + ", " + rawName + ") called"));
        }
        try {
            if (rawName.equals("table")) {
                this.currTable = null;
            } else if (rawName.equals("column")) {
                this.currColumn = null;
            } else if (rawName.equals("foreign-key")) {
                this.currFK = null;
            } else if (rawName.equals("index")) {
                this.currIndex = null;
            } else if (rawName.equals("unique")) {
                this.currUnique = null;
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void setOption(Attributes attributes) {
        String key = attributes.getValue("key");
        String value = attributes.getValue("value");
        if (this.currUnique != null) {
            this.currUnique.addOption(key, value);
        } else if (this.currIndex != null) {
            this.currIndex.addOption(key, value);
        } else if (this.currFK != null) {
            this.currFK.addOption(key, value);
        } else if (this.currColumn != null) {
            this.currColumn.addOption(key, value);
        } else if (this.currTable != null) {
            this.currTable.addOption(key, value);
        } else {
            this.database.addOption(key, value);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        log.error((Object)"Sax parser threw an Exception", (Throwable)e);
        throw new SAXException("Error while parsing " + this.currentXmlFile + " at line " + e.getLineNumber() + " column " + e.getColumnNumber() + " : " + e.getMessage());
    }

    static {
        saxFactory.setValidating(true);
    }

    private static class ParseStackElement {
        private boolean isExternalSchema;
        private String currentPackage;
        private String currentXmlFile;
        private boolean firstPass;

        public ParseStackElement(XmlToAppData parser) {
            this.isExternalSchema = parser.isExternalSchema;
            this.currentPackage = parser.currentPackage;
            this.currentXmlFile = parser.currentXmlFile;
            this.firstPass = parser.firstPass;
            parser.parsingStack.push(this);
        }

        public static void popState(XmlToAppData parser) {
            if (!parser.parsingStack.isEmpty()) {
                ParseStackElement elem = (ParseStackElement)parser.parsingStack.pop();
                parser.isExternalSchema = elem.isExternalSchema;
                parser.currentPackage = elem.currentPackage;
                parser.currentXmlFile = elem.currentXmlFile;
                parser.firstPass = elem.firstPass;
            }
        }

        public static void pushState(XmlToAppData parser) {
            new ParseStackElement(parser);
        }
    }
}

