/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.transform;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDResolver
implements EntityResolver {
    public static final String WEB_SITE_DTD = "http://db.apache.org/torque/dtd/database_3_3.dtd";
    public static final String WEB_SITE_DTD_3_2 = "http://db.apache.org/torque/dtd/database_3_2.dtd";
    private static Log log = LogFactory.getLog((Class)DTDResolver.class);

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (WEB_SITE_DTD.equals(systemId)) {
            return this.readFromClasspath("database.dtd");
        }
        if (WEB_SITE_DTD_3_2.equals(systemId)) {
            return this.readFromClasspath("database_3_2.dtd");
        }
        log.debug((Object)"Resolver: used default behaviour");
        return null;
    }

    private InputSource readFromClasspath(String resourceName) throws SAXException {
        try {
            InputStream dtdStream = this.getClass().getResourceAsStream(resourceName);
            if (dtdStream != null) {
                String pkg = this.getClass().getName().substring(0, this.getClass().getName().lastIndexOf(46));
                log.debug((Object)("Resolver: used " + resourceName + " from '" + pkg + "' package"));
                return new InputSource(dtdStream);
            }
            log.warn((Object)"Could not locate database.dtd");
            return null;
        }
        catch (Exception ex) {
            throw new SAXException("Could not get stream for " + resourceName, ex);
        }
    }
}

