/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Domain;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.NameFactory;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.platform.Platform;
import org.apache.torque.engine.platform.PlatformFactory;
import org.xml.sax.Attributes;

public class Database {
    private static Log log = LogFactory.getLog((Class)Database.class);
    private String databaseType = null;
    private List tableList = new ArrayList(100);
    private Map domainMap = new HashMap();
    private String name;
    private String javaName;
    private String pkg;
    private String baseClass;
    private String basePeer;
    private String defaultIdMethod;
    private String defaultJavaType;
    private String defaultJavaNamingMethod;
    private Hashtable tablesByName = new Hashtable();
    private Hashtable tablesByJavaName = new Hashtable();
    private boolean heavyIndexing;
    private String fileName;
    private Map options = Collections.synchronizedMap(new ListOrderedMap());

    public Database(String databaseType) {
        this.databaseType = databaseType;
    }

    public void loadFromXML(Attributes attrib) {
        this.setName(attrib.getValue("name"));
        this.pkg = attrib.getValue("package");
        this.baseClass = attrib.getValue("baseClass");
        this.basePeer = attrib.getValue("basePeer");
        this.defaultJavaType = attrib.getValue("defaultJavaType");
        this.defaultIdMethod = attrib.getValue("defaultIdMethod");
        this.defaultJavaNamingMethod = attrib.getValue("defaultJavaNamingMethod");
        if (this.defaultJavaNamingMethod == null) {
            this.defaultJavaNamingMethod = "underscore";
        }
        this.heavyIndexing = "true".equals(attrib.getValue("heavyIndexing"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "default" : name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackage(String v) {
        this.pkg = v;
    }

    public String getBaseClass() {
        if (this.baseClass == null) {
            return "BaseObject";
        }
        return this.baseClass;
    }

    public void setBaseClass(String v) {
        this.baseClass = v;
    }

    public String getBasePeer() {
        if (this.basePeer == null) {
            return "BasePeer";
        }
        return this.basePeer;
    }

    public void setBasePeer(String v) {
        this.basePeer = v;
    }

    public String getDefaultIdMethod() {
        return this.defaultIdMethod;
    }

    public void setDefaultIdMethod(String v) {
        this.defaultIdMethod = v;
    }

    public String getDefaultJavaType() {
        return this.defaultJavaType;
    }

    public String getDefaultJavaNamingMethod() {
        return this.defaultJavaNamingMethod;
    }

    public void setDefaultJavaNamingMethod(String v) {
        this.defaultJavaNamingMethod = v;
    }

    public boolean isHeavyIndexing() {
        return this.heavyIndexing;
    }

    public void setHeavyIndexing(boolean v) {
        this.heavyIndexing = v;
    }

    public List getTables() {
        return this.tableList;
    }

    public Table getTable(String name) {
        return (Table)this.tablesByName.get(name);
    }

    public Table getTableByJavaName(String javaName) {
        return (Table)this.tablesByJavaName.get(javaName);
    }

    public Table addTable(Attributes attrib) {
        Table tbl = new Table();
        tbl.setDatabase(this);
        tbl.loadFromXML(attrib, this.getDefaultIdMethod());
        this.addTable(tbl);
        return tbl;
    }

    public void addTable(Table tbl) {
        tbl.setDatabase(this);
        this.tableList.add(tbl);
        this.tablesByName.put(tbl.getName(), tbl);
        this.tablesByJavaName.put(tbl.getJavaName(), tbl);
        tbl.setPackage(this.getPackage());
    }

    public void addDomain(Domain domain) {
        this.domainMap.put(domain.getName(), domain);
    }

    public Domain getDomain(String domainName) {
        return (Domain)this.domainMap.get(domainName);
    }

    protected String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public Platform getPlatform() {
        return PlatformFactory.getPlatformFor(this.databaseType);
    }

    public boolean requiresIdTable() {
        Iterator iter = this.getTables().iterator();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (!table.getIdMethod().equals("idbroker")) continue;
            return true;
        }
        return false;
    }

    public void doFinalInitialization() throws EngineException {
        Iterator iter = this.getTables().iterator();
        while (iter.hasNext()) {
            Table currTable = (Table)iter.next();
            if (currTable.getIdMethod().equals("autoincrement")) {
                boolean foundOne = false;
                Iterator colIter = currTable.getColumns().iterator();
                while (colIter.hasNext() && !foundOne) {
                    foundOne = ((Column)colIter.next()).isAutoIncrement();
                }
                if (!foundOne) {
                    String errorMessage = "Table '" + currTable.getName() + "' is marked as autoincrement, but it does not " + "have a column which declared as the one to " + "auto increment (i.e. autoIncrement=\"true\")\n";
                    throw new EngineException("Error in XML schema: " + errorMessage);
                }
            }
            currTable.doFinalInitialization();
            Iterator fks = currTable.getForeignKeys().iterator();
            while (fks.hasNext()) {
                ForeignKey currFK = (ForeignKey)fks.next();
                Table foreignTable = this.getTable(currFK.getForeignTableName());
                if (foreignTable == null) {
                    throw new EngineException("Attempt to set foreign key to nonexistent table, " + currFK.getForeignTableName());
                }
                List referrers = foreignTable.getReferrers();
                if (referrers == null || !referrers.contains(currFK)) {
                    foreignTable.addReferrer(currFK);
                }
                Iterator localColumnNames = currFK.getLocalColumns().iterator();
                while (localColumnNames.hasNext()) {
                    Column local = currTable.getColumn((String)localColumnNames.next());
                    if (local == null) {
                        throw new EngineException("Attempt to define foreign key with nonexistent column in table, " + currTable.getName());
                    }
                    if (!local.isPrimaryKey()) continue;
                    currTable.setContainsForeignPK(true);
                }
                Iterator foreignColumnNames = currFK.getForeignColumns().iterator();
                while (foreignColumnNames.hasNext()) {
                    String foreignColumnName = (String)foreignColumnNames.next();
                    Column foreign = foreignTable.getColumn(foreignColumnName);
                    if (foreign == null) {
                        throw new EngineException("Attempt to set foreign key to nonexistent column: table=" + currTable.getName() + ", foreign column=" + foreignColumnName);
                    }
                    foreign.addReferrer(currFK);
                }
            }
        }
    }

    public String getJavaName() {
        if (this.javaName == null) {
            ArrayList<String> inputs = new ArrayList<String>(2);
            inputs.add(this.name);
            inputs.add(this.defaultJavaNamingMethod);
            try {
                this.javaName = NameFactory.generateName(NameFactory.JAVA_GENERATOR, inputs);
            }
            catch (EngineException e) {
                log.error((Object)e, (Throwable)((Object)e));
            }
        }
        return this.javaName;
    }

    public String getStandardJavaName() {
        if (this.javaName == null) {
            ArrayList<String> inputs = new ArrayList<String>(2);
            inputs.add(this.name);
            inputs.add("javaname");
            try {
                this.javaName = NameFactory.generateName(NameFactory.JAVA_GENERATOR, inputs);
            }
            catch (EngineException e) {
                log.error((Object)e, (Throwable)((Object)e));
            }
        }
        return this.javaName;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\"?>\n");
        result.append("<!DOCTYPE database SYSTEM \"http://db.apache.org/torque/dtd/database_3_3.dtd\">\n");
        result.append("<!-- Autogenerated by SQLToXMLSchema! -->\n");
        result.append("<database name=\"").append(this.getName()).append('\"').append(" package=\"").append(this.getPackage()).append('\"').append(" defaultIdMethod=\"").append(this.getDefaultIdMethod()).append('\"').append(" baseClass=\"").append(this.getBaseClass()).append('\"').append(" basePeer=\"").append(this.getBasePeer()).append('\"').append(">\n");
        Iterator i = this.tableList.iterator();
        while (i.hasNext()) {
            result.append(i.next());
        }
        result.append("</database>");
        return result.toString();
    }

    public void addOption(String key, String value) {
        this.options.put(key, value);
    }

    public String getOption(String key) {
        return (String)this.options.get(key);
    }

    public Map getOptions() {
        return this.options;
    }
}

