/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sequencing;

import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.sequencing.SequencingConnectionHandler;
import oracle.toplink.essentials.threetier.ConnectionPool;

class ServerSessionConnectionHandler
implements SequencingConnectionHandler {
    ConnectionPool pool;

    ServerSessionConnectionHandler(ConnectionPool pool) {
        this.pool = pool;
    }

    public void onConnect() {
        if (!this.isConnected()) {
            this.pool.startUp();
        }
    }

    public boolean isConnected() {
        return this.pool.isConnected();
    }

    public Accessor acquireAccessor() {
        return this.pool.acquireConnection();
    }

    public void releaseAccessor(Accessor accessor) {
        this.pool.releaseConnection(accessor);
    }

    public void onDisconnect() {
        if (this.isConnected()) {
            this.pool.shutDown();
        }
    }

    protected void finalize() throws Throwable {
        this.onDisconnect();
    }
}

