/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.threetier;

import oracle.toplink.essentials.exceptions.ConcurrencyException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.sessions.Login;
import oracle.toplink.essentials.threetier.ConnectionPool;
import oracle.toplink.essentials.threetier.ServerSession;

public class ExternalConnectionPool
extends ConnectionPool {
    protected Accessor cachedConnection;

    public ExternalConnectionPool() {
    }

    public ExternalConnectionPool(String name, Login login, ServerSession owner) {
        super(name, login, 0, 0, owner);
    }

    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        return (Accessor)this.getCachedConnection().clone();
    }

    protected Accessor getCachedConnection() {
        return this.cachedConnection;
    }

    public boolean hasConnectionAvailable() {
        return true;
    }

    public boolean isThereConflictBetweenLoginAndType() {
        return !this.getLogin().shouldUseExternalConnectionPooling();
    }

    public synchronized void releaseConnection(Accessor connection) throws DatabaseException {
        this.getConnectionsUsed().removeElement(connection);
        connection.closeConnection();
        this.notify();
    }

    protected void setCachedConnection(Accessor cachedConnection) {
        this.cachedConnection = cachedConnection;
    }

    public synchronized void shutDown() {
        this.setIsConnected(false);
    }

    public synchronized void startUp() {
        this.setCachedConnection(this.buildConnection());
        this.setIsConnected(true);
    }
}

