/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.expressions.ExpressionOperator;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.converters.ObjectTypeConverter;
import oracle.toplink.essentials.sessions.Session;

public class ExpressionOperatorConverter
extends ObjectTypeConverter {
    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        Object fieldValue;
        if (attributeValue == null) {
            fieldValue = this.getAttributeToFieldValues().get(Helper.getNullWrapper());
        } else {
            fieldValue = this.getAttributeToFieldValues().get(attributeValue);
            if (fieldValue == null) {
                if (((ExpressionOperator)attributeValue).getDatabaseStrings() != null) {
                    String databaseString = ((ExpressionOperator)attributeValue).getDatabaseStrings()[0];
                    fieldValue = databaseString.substring(0, databaseString.length() - 1);
                } else {
                    throw DescriptorException.noAttributeValueConversionToFieldValueProvided(attributeValue, this.getMapping());
                }
            }
        }
        return fieldValue;
    }

    public Object convertDataValueToObjectValue(Object fieldValue, Session session) {
        ExpressionOperator attributeValue = null;
        if (fieldValue == null) {
            attributeValue = (ExpressionOperator)this.getFieldToAttributeValues().get(Helper.getNullWrapper());
        } else {
            try {
                fieldValue = ((AbstractSession)session).getDatasourcePlatform().getConversionManager().convertObject(fieldValue, this.getFieldClassification());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), e);
            }
            attributeValue = (ExpressionOperator)this.getFieldToAttributeValues().get(fieldValue);
            if (attributeValue == null) {
                attributeValue = ExpressionOperator.simpleFunction(0, (String)fieldValue);
            }
        }
        return attributeValue;
    }
}

