/*
 * Decompiled with CFR 0.152.
 */
package top.zibin.luban;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import top.zibin.luban.Checker;
import top.zibin.luban.CompressionPredicate;
import top.zibin.luban.Engine;
import top.zibin.luban.InputStreamProvider;
import top.zibin.luban.OnCompressListener;

public class Luban
implements Handler.Callback {
    private static final String TAG = "Luban";
    private static final String DEFAULT_DISK_CACHE_DIR = "luban_disk_cache";
    private static final int MSG_COMPRESS_SUCCESS = 0;
    private static final int MSG_COMPRESS_START = 1;
    private static final int MSG_COMPRESS_ERROR = 2;
    private String mTargetDir;
    private List<InputStreamProvider> mStreamProviders;
    private int mLeastCompressSize;
    private OnCompressListener mCompressListener;
    private CompressionPredicate mCompressionPredicate;
    private Handler mHandler;

    private Luban(Builder builder) {
        this.mStreamProviders = builder.mStreamProviders;
        this.mTargetDir = builder.mTargetDir;
        this.mCompressListener = builder.mCompressListener;
        this.mLeastCompressSize = builder.mLeastCompressSize;
        this.mCompressionPredicate = builder.mCompressionPredicate;
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    private File getImageCacheFile(Context context, String suffix) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            this.mTargetDir = this.getImageCacheDir(context).getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + System.currentTimeMillis() + (int)(Math.random() * 1000.0) + (TextUtils.isEmpty((CharSequence)suffix) ? ".jpg" : suffix);
        return new File(cacheBuilder);
    }

    @Nullable
    private File getImageCacheDir(Context context) {
        return Luban.getImageCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    @Nullable
    private static File getImageCacheDir(Context context, String cacheName) {
        File cacheDir = context.getExternalCacheDir();
        if (cacheDir != null) {
            File result = new File(cacheDir, cacheName);
            if (!(result.mkdirs() || result.exists() && result.isDirectory())) {
                return null;
            }
            return result;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    @UiThread
    private void launch(final Context context) {
        if (this.mStreamProviders == null || this.mStreamProviders.size() == 0 && this.mCompressListener != null) {
            this.mCompressListener.onError(new NullPointerException("image file cannot be null"));
        }
        Iterator<InputStreamProvider> iterator = this.mStreamProviders.iterator();
        while (iterator.hasNext()) {
            final InputStreamProvider path = iterator.next();
            if (Checker.isImage(path.getPath())) {
                AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(1));
                            File result = Luban.this.mCompressionPredicate != null ? (Luban.this.mCompressionPredicate.apply(path.getPath()) ? (Checker.isNeedCompress(Luban.this.mLeastCompressSize, path.getPath()) ? new Engine(path, Luban.this.getImageCacheFile(context, Checker.checkSuffix(path.getPath()))).compress() : new File(path.getPath())) : new File(path.getPath())) : (Checker.isNeedCompress(Luban.this.mLeastCompressSize, path.getPath()) ? new Engine(path, Luban.this.getImageCacheFile(context, Checker.checkSuffix(path.getPath()))).compress() : new File(path.getPath()));
                            Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(0, (Object)result));
                        }
                        catch (IOException e) {
                            Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(2, (Object)e));
                        }
                    }
                });
            } else {
                this.mCompressListener.onError(new IllegalArgumentException("can not read the path : " + path));
            }
            iterator.remove();
        }
    }

    @WorkerThread
    private File get(InputStreamProvider path, Context context) throws IOException {
        return new Engine(path, this.getImageCacheFile(context, Checker.checkSuffix(path.getPath()))).compress();
    }

    @WorkerThread
    private List<File> get(Context context) throws IOException {
        ArrayList<File> results = new ArrayList<File>();
        Iterator<InputStreamProvider> iterator = this.mStreamProviders.iterator();
        while (iterator.hasNext()) {
            InputStreamProvider path = iterator.next();
            if (Checker.isImage(path.getPath())) {
                if (this.mCompressionPredicate != null) {
                    results.add(this.mCompressionPredicate.apply(path.getPath()) ? new Engine(path, this.getImageCacheFile(context, Checker.checkSuffix(path.getPath()))).compress() : new File(path.getPath()));
                } else {
                    results.add(new Engine(path, this.getImageCacheFile(context, Checker.checkSuffix(path.getPath()))).compress());
                }
            }
            iterator.remove();
        }
        return results;
    }

    public boolean handleMessage(Message msg) {
        if (this.mCompressListener == null) {
            return false;
        }
        switch (msg.what) {
            case 1: {
                this.mCompressListener.onStart();
                break;
            }
            case 0: {
                this.mCompressListener.onSuccess((File)msg.obj);
                break;
            }
            case 2: {
                this.mCompressListener.onError((Throwable)msg.obj);
            }
        }
        return false;
    }

    public static class Builder {
        private Context context;
        private String mTargetDir;
        private List<InputStreamProvider> mStreamProviders;
        private int mLeastCompressSize = 100;
        private OnCompressListener mCompressListener;
        private CompressionPredicate mCompressionPredicate;

        Builder(Context context) {
            this.context = context;
            this.mStreamProviders = new ArrayList<InputStreamProvider>();
        }

        private Luban build() {
            return new Luban(this);
        }

        public Builder load(InputStreamProvider inputStreamProvider) {
            this.mStreamProviders.add(inputStreamProvider);
            return this;
        }

        public Builder load(final File file) {
            this.mStreamProviders.add(new InputStreamProvider(){

                @Override
                public InputStream open() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public String getPath() {
                    return file.getAbsolutePath();
                }
            });
            return this;
        }

        public Builder load(final String string) {
            this.mStreamProviders.add(new InputStreamProvider(){

                @Override
                public InputStream open() throws IOException {
                    return new FileInputStream(string);
                }

                @Override
                public String getPath() {
                    return string;
                }
            });
            return this;
        }

        public Builder load(List<String> list) {
            for (String s : list) {
                this.load(s);
            }
            return this;
        }

        public Builder load(final Uri uri) {
            this.mStreamProviders.add(new InputStreamProvider(){

                @Override
                public InputStream open() throws IOException {
                    return Builder.this.context.getContentResolver().openInputStream(uri);
                }

                @Override
                public String getPath() {
                    return uri.getPath();
                }
            });
            return this;
        }

        public Builder putGear(int gear) {
            return this;
        }

        public Builder setCompressListener(OnCompressListener listener) {
            this.mCompressListener = listener;
            return this;
        }

        public Builder setTargetDir(String targetDir) {
            this.mTargetDir = targetDir;
            return this;
        }

        public Builder ignoreBy(int size) {
            this.mLeastCompressSize = size;
            return this;
        }

        public Builder filter(CompressionPredicate compressionPredicate) {
            this.mCompressionPredicate = compressionPredicate;
            return this;
        }

        public void launch() {
            this.build().launch(this.context);
        }

        public File get(final String path) throws IOException {
            return this.build().get(new InputStreamProvider(){

                @Override
                public InputStream open() throws IOException {
                    return new FileInputStream(path);
                }

                @Override
                public String getPath() {
                    return path;
                }
            }, this.context);
        }

        public List<File> get() throws IOException {
            return this.build().get(this.context);
        }
    }
}

