/*
 * Decompiled with CFR 0.152.
 */
package top.zibin.luban;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.support.media.ExifInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import top.zibin.luban.Checker;
import top.zibin.luban.InputStreamProvider;

class Engine {
    private ExifInterface srcExif;
    private InputStreamProvider srcImg;
    private File tagImg;
    private int srcWidth;
    private int srcHeight;

    Engine(InputStreamProvider srcImg, File tagImg) throws IOException {
        if (Checker.isJPG(srcImg.getPath())) {
            this.srcExif = new ExifInterface(srcImg.open());
        }
        this.tagImg = tagImg;
        this.srcImg = srcImg;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        BitmapFactory.decodeStream((InputStream)srcImg.open(), null, (BitmapFactory.Options)options);
        this.srcWidth = options.outWidth;
        this.srcHeight = options.outHeight;
    }

    private int computeSize() {
        this.srcWidth = this.srcWidth % 2 == 1 ? this.srcWidth + 1 : this.srcWidth;
        this.srcHeight = this.srcHeight % 2 == 1 ? this.srcHeight + 1 : this.srcHeight;
        int longSide = Math.max(this.srcWidth, this.srcHeight);
        int shortSide = Math.min(this.srcWidth, this.srcHeight);
        float scale = (float)shortSide / (float)longSide;
        if (scale <= 1.0f && (double)scale > 0.5625) {
            if (longSide < 1664) {
                return 1;
            }
            if (longSide < 4990) {
                return 2;
            }
            if (longSide > 4990 && longSide < 10240) {
                return 4;
            }
            return longSide / 1280 == 0 ? 1 : longSide / 1280;
        }
        if ((double)scale <= 0.5625 && (double)scale > 0.5) {
            return longSide / 1280 == 0 ? 1 : longSide / 1280;
        }
        return (int)Math.ceil((double)longSide / (1280.0 / (double)scale));
    }

    private Bitmap rotatingImage(Bitmap bitmap) {
        if (this.srcExif == null) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        int angle = 0;
        int orientation = this.srcExif.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                angle = 90;
                break;
            }
            case 3: {
                angle = 180;
                break;
            }
            case 8: {
                angle = 270;
            }
        }
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    File compress() throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.computeSize();
        Bitmap tagBitmap = BitmapFactory.decodeStream((InputStream)this.srcImg.open(), null, (BitmapFactory.Options)options);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        tagBitmap = this.rotatingImage(tagBitmap);
        tagBitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)stream);
        tagBitmap.recycle();
        FileOutputStream fos = new FileOutputStream(this.tagImg);
        fos.write(stream.toByteArray());
        fos.flush();
        fos.close();
        stream.close();
        return this.tagImg;
    }
}

