/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.Range;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.Alignment;
import jxl.format.BoldStyle;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.util.DateUtil;
import top.ibase4j.core.util.MathUtil;

public class DownloadExcelUtil {
    private static final Logger logger = LogManager.getLogger();
    private Integer icol = 0;
    private Integer irow = -1;
    private OutputStream os;
    private WritableWorkbook wbook;
    private WritableSheet wsheet;
    private WritableCellFormat wcfFC;
    private WritableFont wfont;
    private Integer trow = -1;
    private Integer titleCols = 0;
    private long startTime = System.currentTimeMillis();
    private int sheetIndex = 0;
    private String sheetName;

    public DownloadExcelUtil(HttpServletResponse response, String fileName, String sheetName) throws IOException {
        if (fileName.indexOf(".xls") < 0) {
            fileName = fileName + ".xls";
        }
        if (response != null && response instanceof HttpServletResponse) {
            logger.warn("Write Excel To Memory.Please wait...");
            response.reset();
            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GB2312"), "ISO8859-1"));
            this.os = response.getOutputStream();
            this.os.flush();
            this.wbook = Workbook.createWorkbook((OutputStream)this.os);
        } else {
            logger.warn("Write Excel To Disk.Please wait...");
            this.wbook = Workbook.createWorkbook((File)new File(fileName));
        }
        this.sheetName = sheetName;
        this.wsheet = this.wbook.createSheet(sheetName, this.sheetIndex++);
    }

    public void addSheet(String sheetName) {
        this.irow = -1;
        this.sheetName = sheetName;
        this.wsheet = this.wbook.createSheet(sheetName, this.sheetIndex++);
    }

    public void setReportTitle(String reportTitle) throws WriteException, IOException {
        try {
            Integer n = this.irow;
            Integer n2 = this.irow = Integer.valueOf(this.irow + 1);
            this.wfont = new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 12, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
            this.wcfFC = new WritableCellFormat(this.wfont);
            this.wcfFC.setAlignment(Alignment.CENTRE);
            this.wcfFC.setVerticalAlignment(VerticalAlignment.CENTRE);
            this.wsheet.addCell((WritableCell)new Label(this.icol.intValue(), this.irow.intValue(), reportTitle, (CellFormat)this.wcfFC));
            this.trow = this.irow;
        }
        catch (Exception e) {
            this.close();
        }
    }

    @Deprecated
    public void setExcelListTitle(String[] listTitle) throws WriteException, IOException {
        try {
            Integer n = this.irow;
            Integer n2 = this.irow = Integer.valueOf(this.irow + 1);
            long start = System.currentTimeMillis();
            this.wfont = new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 10, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
            this.wcfFC = new WritableCellFormat(this.wfont);
            this.wcfFC.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            this.wcfFC.setAlignment(Alignment.CENTRE);
            this.wcfFC.setVerticalAlignment(VerticalAlignment.CENTRE);
            for (int i = this.icol.intValue(); i < listTitle.length; ++i) {
                this.wsheet.addCell((WritableCell)new Label(i, this.irow.intValue(), listTitle[i], (CellFormat)this.wcfFC));
            }
            this.trow = this.irow;
            logger.info("title use time:" + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            this.close();
        }
    }

    public void addRow(Object[] strings, BorderLineStyle borderLineStyle, Alignment alignment, String bold) throws WriteException, IOException {
        try {
            Integer n = this.irow;
            Integer n2 = this.irow = Integer.valueOf(this.irow + 1);
            bold = StringUtils.isEmpty((CharSequence)bold) ? "" : bold;
            for (int i = 0; i < strings.length; ++i) {
                this.wfont = "bold".equals(bold.toLowerCase()) ? new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 10, WritableFont.BOLD, false) : new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 10, WritableFont.NO_BOLD, false);
                this.wcfFC = new WritableCellFormat(this.wfont);
                this.wcfFC.setAlignment(alignment);
                this.wcfFC.setVerticalAlignment(VerticalAlignment.CENTRE);
                if (borderLineStyle == BorderLineStyle.THIN && i == strings.length - 1) {
                    this.wcfFC.setBorder(Border.ALL, borderLineStyle);
                    this.wcfFC.setBorder(Border.RIGHT, BorderLineStyle.MEDIUM);
                } else {
                    this.wcfFC.setBorder(Border.ALL, borderLineStyle);
                }
                this.wsheet.addCell((WritableCell)new Label(i, this.irow.intValue(), strings[i] == null ? "" : strings[i].toString(), (CellFormat)this.wcfFC));
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            this.close();
        }
    }

    public void addRow(Object[] strings, CellType[] cellTypes, DisplayFormat ... dFormat) throws WriteException, IOException {
        try {
            Integer n = this.irow;
            Integer n2 = this.irow = Integer.valueOf(this.irow + 1);
            DisplayFormat format = null;
            for (int i = 0; i < strings.length; ++i) {
                if (dFormat != null) {
                    if (dFormat.length > i) {
                        format = dFormat[i];
                    } else if (dFormat.length > 0) {
                        format = dFormat[0];
                    }
                }
                this.addCell(i, this.irow, strings[i] == null ? "" : strings[i].toString(), cellTypes[i], format, false, i + 1 == strings.length);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            this.close();
        }
    }

    public void addRows(List<?> infoList, CellType[] cellTypes, DisplayFormat ... dFormat) throws WriteException, IOException {
        if (infoList != null && !infoList.isEmpty()) {
            CellType cellType = CellType.EMPTY;
            DisplayFormat format = null;
            while (0 < infoList.size()) {
                if (this.irow == 50000) {
                    this.write();
                    this.addSheet(this.sheetName);
                }
                Integer n = this.irow;
                Integer n2 = this.irow = Integer.valueOf(this.irow + 1);
                Object[] rowInfo = (Object[])infoList.get(0);
                if (rowInfo.length > this.titleCols) {
                    this.titleCols = rowInfo.length;
                }
                for (int j = this.icol.intValue(); j < rowInfo.length; ++j) {
                    Object object = rowInfo[j] = rowInfo[j] == null ? "" : rowInfo[j];
                    cellType = cellTypes != null && j < cellTypes.length ? (cellTypes[j] == null ? CellType.EMPTY : cellTypes[j]) : CellType.EMPTY;
                    if (dFormat != null) {
                        if (dFormat.length > j) {
                            format = dFormat[j];
                        } else if (dFormat.length > 0) {
                            format = dFormat[0];
                        }
                    }
                    this.addCell(j, this.irow, rowInfo[j], cellType, format, 1 == infoList.size(), j == rowInfo.length - 1);
                }
                infoList.remove(0);
            }
            try {
                if (this.os != null) {
                    this.os.flush();
                }
                if (this.trow >= 0) {
                    this.wsheet.mergeCells(this.icol.intValue(), this.trow.intValue(), this.titleCols + this.icol - 1, this.trow.intValue());
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                this.close();
            }
        }
    }

    public void reportExcel() throws WriteException, IOException {
        logger.info("Use time:" + MathUtil.divide(System.currentTimeMillis() - this.startTime, 1000) + "s");
        this.flush();
        logger.info("ReportExcel Successful!!!");
    }

    public void setMergeCells(int col, int row, int toCol, int toRow) throws WriteException, IOException {
        try {
            this.wsheet.mergeCells(col, row, toCol, toRow);
        }
        catch (Exception e) {
            this.close();
        }
    }

    public void close() throws WriteException, IOException {
        if (this.wbook != null) {
            this.wbook.write();
            this.wbook.close();
        }
        if (this.os != null) {
            this.os.flush();
            this.os.close();
        }
    }

    public void write() throws WriteException, IOException {
        this.setRowView();
        this.setColumnView();
        if (this.os != null) {
            this.os.flush();
        }
    }

    private void flush() throws WriteException, IOException {
        this.setRowView();
        this.setColumnView();
        this.close();
    }

    public void osFlush() throws IOException, WriteException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    public void addCell(Integer col, Integer row, Object o, CellType type, DisplayFormat format, Boolean isLastRow, Boolean isLastCols) throws WriteException, IOException {
        WritableFont wfont = new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
        try {
            if (o instanceof ArrayList) {
                Label Label2 = new Label(col.intValue(), row.intValue(), "", (CellFormat)this.wcfFC);
                WritableCellFeatures wcf = new WritableCellFeatures();
                if (!((List)o).isEmpty()) {
                    wcf.setDataValidationList((Collection)((List)o));
                }
                Label2.setCellFeatures(wcf);
                this.wsheet.addCell((WritableCell)Label2);
            } else {
                if (type == CellType.LABEL) {
                    wfont = new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 10, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
                    this.wcfFC = new WritableCellFormat(wfont);
                    this.wcfFC.setAlignment(Alignment.CENTRE);
                } else if (type == CellType.STRING_FORMULA) {
                    this.wcfFC = new WritableCellFormat(wfont);
                    this.wcfFC.setAlignment(Alignment.LEFT);
                } else if (type == CellType.NUMBER) {
                    this.wcfFC = new WritableCellFormat(wfont, format);
                    this.wcfFC.setAlignment(Alignment.RIGHT);
                } else if (type == CellType.DATE || type == CellType.DATE_FORMULA) {
                    this.wcfFC = new WritableCellFormat(wfont, format);
                    this.wcfFC.setAlignment(Alignment.CENTRE);
                } else {
                    this.wcfFC = new WritableCellFormat(wfont);
                    this.wcfFC.setAlignment(Alignment.CENTRE);
                }
                this.wcfFC.setVerticalAlignment(VerticalAlignment.CENTRE);
                this.wcfFC.setBorder(Border.ALL, BorderLineStyle.THIN);
                if (isLastCols.booleanValue()) {
                    this.wcfFC.setBorder(Border.RIGHT, BorderLineStyle.MEDIUM);
                }
                if (isLastRow.booleanValue()) {
                    this.wcfFC.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM);
                }
                if (o == null) {
                    this.wsheet.addCell((WritableCell)new Label(col.intValue(), row.intValue(), ""));
                } else if (StringUtils.isEmpty((CharSequence)String.valueOf(o))) {
                    this.wsheet.addCell((WritableCell)new Label(col.intValue(), row.intValue(), o.toString(), (CellFormat)this.wcfFC));
                } else if (type == CellType.NUMBER) {
                    this.wsheet.addCell((WritableCell)new Number(col.intValue(), row.intValue(), Double.valueOf(String.valueOf(o)).doubleValue(), (CellFormat)this.wcfFC));
                } else if (type == CellType.DATE || type == CellType.DATE_FORMULA) {
                    this.wsheet.addCell((WritableCell)new DateTime(col.intValue(), row.intValue(), DateUtil.stringToDate(o.toString()), (CellFormat)this.wcfFC));
                } else {
                    this.wsheet.addCell((WritableCell)new Label(col.intValue(), row.intValue(), o.toString(), (CellFormat)this.wcfFC));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
        }
    }

    private void setRowView() throws WriteException, IOException {
        try {
            for (int i = 0; i < this.wsheet.getRows(); ++i) {
                this.wsheet.setRowView(i, (int)((double)this.wsheet.getRowView(i).getDimension() * 1.3));
            }
        }
        catch (Exception e) {
            this.close();
        }
    }

    private void setColumnView() {
        Pattern pattern = Pattern.compile("\\d+(.\\d+)?$");
        for (int i = 0; i < this.wsheet.getRows(); ++i) {
            block1: for (int j = 0; j < this.wsheet.getColumns(); ++j) {
                int infoWidth;
                Range[] range = this.wsheet.getMergedCells();
                for (int k = 0; k < range.length; ++k) {
                    if (range[k].getTopLeft().getRow() == i && range[k].getTopLeft().getColumn() == j && range[k].getBottomRight().getColumn() != j) continue block1;
                }
                Cell cell = this.wsheet.getCell(j, i);
                String value = cell.getContents();
                if (cell.getType() == CellType.DATE) {
                    infoWidth = (int)Math.round((double)value.length() * 0.5);
                } else if (cell.getType() == CellType.NUMBER) {
                    int p = 0;
                    for (int k = 0; k < value.split("\\.")[0].length(); ++k) {
                        if (value.charAt(k) != '0') continue;
                        ++p;
                    }
                    infoWidth = (int)Math.round((double)(value.length() * 2) + (double)p * 0.2);
                } else {
                    infoWidth = pattern.matcher(value).matches() ? (int)Math.round((double)value.length() * 1.2) : (cell.getCellFormat() != null && cell.getCellFormat().getFont().getBoldWeight() == BoldStyle.BOLD.getValue() ? (int)Math.round((double)value.getBytes().length * 1.13) : (value.getBytes().length != value.length() ? (int)Math.round((double)value.length() * 1.9) : (int)Math.round((double)value.length() * 1.05)));
                }
                int cellWidth = this.wsheet.getColumnView(j).getDimension();
                if (cellWidth >= infoWidth) continue;
                this.wsheet.setColumnView(j, infoWidth);
            }
        }
    }

    public void setHideCol(int rols) {
        CellView view = new CellView();
        view.setHidden(true);
        this.wsheet.setColumnView(rols, view);
    }

    public void setHideRow(int row) throws RowsExceededException {
        CellView view = new CellView();
        view.setHidden(true);
        this.wsheet.setRowView(row, view);
    }

    public void deleteCol(int rols) {
        this.wsheet.removeColumn(rols);
    }

    public void deleteRow(int row) {
        this.wsheet.removeRow(row);
    }

    public void setIrow(Integer row) {
        this.irow = row;
    }

    public int getIrow() {
        return this.irow;
    }

    public void setIcol(Integer col) {
        this.icol = col;
    }

    public Integer getIcol() {
        return this.icol;
    }

    public Integer getTitleCols() {
        return this.titleCols;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }
}

