/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import top.ibase4j.core.exception.BusinessException;
import top.ibase4j.core.support.cache.CacheManager;
import top.ibase4j.core.util.PropertiesUtil;

public class CacheUtil {
    private static CacheManager cacheManager;
    private static CacheManager lockManager;

    public static void setCacheManager(CacheManager cacheManager) {
        CacheUtil.cacheManager = cacheManager;
    }

    public static void setLockManager(CacheManager cacheManager) {
        lockManager = cacheManager;
    }

    public static CacheManager getCache() {
        return cacheManager;
    }

    public static CacheManager getLockManager() {
        return lockManager;
    }

    public static boolean tryLock(String key) {
        int expires = 1000 * PropertiesUtil.getInt("redis.lock.expires", 180);
        return lockManager.setnx(key, Integer.valueOf(expires));
    }

    public static boolean getLock(String key) {
        return lockManager.lock(key);
    }

    public static void unlock(String key) {
        lockManager.unlock(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshTimes(String key, int seconds, int frequency, String message) {
        if (CacheUtil.getLock(key + "-LOCK")) {
            try {
                Integer times = 1;
                String timesStr = (String)CacheUtil.getCache().get(key);
                if (StringUtils.isNotBlank((CharSequence)timesStr) && (times = Integer.valueOf(Integer.valueOf(timesStr) + 1)) > frequency) {
                    throw new BusinessException(message);
                }
                CacheUtil.getCache().set(key, (Serializable)((Object)times.toString()), seconds);
            }
            finally {
                CacheUtil.unlock(key + "-LOCK");
            }
        } else {
            CacheUtil.refreshTimes(key, seconds, frequency, message);
        }
    }
}

