/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.pay;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(value={"alipay"})
@PropertySource(value={"classpath:config/alipay.properties"})
public class AliPayConfig {
    @Autowired
    public Environment env;
    private String privateKey;
    private String alipayPublicKey;
    private String appId;
    private String serviceUrl;
    private String charset;
    private String signType;
    private String format;
    private AlipayClient alipayClient;
    private static AliPayConfig config;

    @Bean
    public AliPayConfig aliPayConfigs() {
        config = new AliPayConfig();
        config.setPrivateKey(this.env.getProperty("alipay.privateKey"));
        config.setAlipayPublicKey(this.env.getProperty("alipay.alipayPulicKey"));
        config.setAppId(this.env.getProperty("alipay.appId"));
        config.setServiceUrl(this.env.getProperty("alipay.serverUrl"));
        config.setCharset(this.env.getProperty("alipay.charset"));
        return config;
    }

    public static AliPayConfig build() {
        AliPayConfig.config.alipayClient = new DefaultAlipayClient(config.getServiceUrl(), config.getAppId(), config.getPrivateKey(), config.getFormat(), config.getCharset(), config.getAlipayPublicKey(), config.getSignType());
        return config;
    }

    public String getPrivateKey() {
        if (StringUtils.isBlank((CharSequence)this.privateKey)) {
            throw new IllegalStateException("privateKey \u672a\u88ab\u8d4b\u503c");
        }
        return this.privateKey;
    }

    public AliPayConfig setPrivateKey(String privateKey) {
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            throw new IllegalArgumentException("privateKey \u503c\u4e0d\u80fd\u4e3a null");
        }
        this.privateKey = privateKey;
        return this;
    }

    public String getAlipayPublicKey() {
        if (StringUtils.isBlank((CharSequence)this.alipayPublicKey)) {
            throw new IllegalStateException("alipayPublicKey \u672a\u88ab\u8d4b\u503c");
        }
        return this.alipayPublicKey;
    }

    public AliPayConfig setAlipayPublicKey(String alipayPublicKey) {
        if (StringUtils.isBlank((CharSequence)alipayPublicKey)) {
            throw new IllegalArgumentException("alipayPublicKey \u503c\u4e0d\u80fd\u4e3a null");
        }
        this.alipayPublicKey = alipayPublicKey;
        return this;
    }

    public String getAppId() {
        if (StringUtils.isBlank((CharSequence)this.appId)) {
            throw new IllegalStateException("appId \u672a\u88ab\u8d4b\u503c");
        }
        return this.appId;
    }

    public AliPayConfig setAppId(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new IllegalArgumentException("appId \u503c\u4e0d\u80fd\u4e3a null");
        }
        this.appId = appId;
        return this;
    }

    public String getServiceUrl() {
        if (StringUtils.isBlank((CharSequence)this.serviceUrl)) {
            throw new IllegalStateException("serviceUrl \u672a\u88ab\u8d4b\u503c");
        }
        return this.serviceUrl;
    }

    public AliPayConfig setServiceUrl(String serviceUrl) {
        if (StringUtils.isBlank((CharSequence)serviceUrl)) {
            serviceUrl = "https://openapi.alipay.com/gateway.do";
        }
        this.serviceUrl = serviceUrl;
        return this;
    }

    public String getCharset() {
        if (StringUtils.isBlank((CharSequence)this.charset)) {
            this.charset = "UTF-8";
        }
        return this.charset;
    }

    public AliPayConfig setCharset(String charset) {
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = "UTF-8";
        }
        this.charset = charset;
        return this;
    }

    public String getSignType() {
        if (StringUtils.isBlank((CharSequence)this.signType)) {
            this.signType = "RSA2";
        }
        return this.signType;
    }

    public AliPayConfig setSignType(String signType) {
        if (StringUtils.isBlank((CharSequence)signType)) {
            signType = "RSA2";
        }
        this.signType = signType;
        return this;
    }

    public String getFormat() {
        if (StringUtils.isBlank((CharSequence)this.format)) {
            this.format = "json";
        }
        return this.format;
    }

    public AlipayClient getAlipayClient() {
        if (this.alipayClient == null) {
            throw new IllegalStateException("alipayClient \u672a\u88ab\u521d\u59cb\u5316");
        }
        return this.alipayClient;
    }
}

