/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.fastdfs;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.FileInfo;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.csource.fastdht.ClientGlobal;
import org.csource.fastdht.FastDHTClient;
import org.csource.fastdht.KeyInfo;
import top.ibase4j.core.support.fastdfs.Config;
import top.ibase4j.core.support.fastdfs.FastDfsFile;
import top.ibase4j.core.support.fastdfs.FileModel;
import top.ibase4j.core.util.PropertiesUtil;

public class FileManager
implements Config {
    private static Logger logger = LogManager.getLogger();
    private TrackerServer trackerServer;
    private StorageServer storageServer;
    private StorageClient storageClient;
    private FastDHTClient fastDHTClient;
    private ExecutorService searchService = Executors.newSingleThreadExecutor();

    public static FileManager getInstance() {
        return new FileManager();
    }

    private FileManager() {
        try {
            TrackerClient trackerClient = new TrackerClient();
            this.trackerServer = trackerClient.getConnection();
            this.storageClient = new StorageClient(this.trackerServer, this.storageServer);
            this.fastDHTClient = new FastDHTClient(true);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public void upload(final FileModel file) {
        logger.info("File Name: " + file.getFilename() + ". File Length: " + file.getContent().length);
        final NameValuePair[] meta_list = new NameValuePair[]{new NameValuePair("mime", file.getMime()), new NameValuePair("size", file.getSize()), new NameValuePair("filename", file.getFilename())};
        long startTime = System.currentTimeMillis();
        String[] uploadResults = null;
        try {
            uploadResults = this.storageClient.upload_file(file.getContent(), file.getExt(), meta_list);
        }
        catch (IOException e) {
            logger.error("IO Exception when uploadind the file: " + file.getFilename(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Non IO Exception when uploadind the file: " + file.getFilename(), (Throwable)e);
        }
        if (uploadResults == null) {
            logger.error("upload file fail, error code: " + this.storageClient.getErrorCode());
        } else {
            final String groupName = uploadResults[0];
            final String remoteFileName = uploadResults[1];
            String fileAbsolutePath = PropertiesUtil.getString("remote.file.uri.prefix") + groupName + "/" + remoteFileName;
            file.setRemotePath(fileAbsolutePath);
            logger.info("upload_file time used: " + (System.currentTimeMillis() - startTime) + " ms. group_name: " + groupName + ", remoteFileName: " + remoteFileName);
            this.searchService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        KeyInfo keyInfo = new KeyInfo(file.getNamespace(), file.getObjectId(), file.getKey());
                        FastDfsFile fastDfsFile = new FastDfsFile();
                        fastDfsFile.setGroupName(groupName);
                        fastDfsFile.setFileName(remoteFileName);
                        fastDfsFile.setNameValuePairs(meta_list);
                        FileManager.this.fastDHTClient.set(keyInfo, JSON.toJSONString((Object)fastDfsFile));
                    }
                    catch (Exception e) {
                        logger.error("", (Throwable)e);
                    }
                }
            });
        }
    }

    public FileInfo getFile(String namespace, String objectId, String key) {
        try {
            KeyInfo keyInfo = new KeyInfo(namespace, objectId, key);
            String info = this.fastDHTClient.get(keyInfo);
            FastDfsFile fastDfsFile = (FastDfsFile)JSON.parseObject((String)info, FastDfsFile.class);
            return this.storageClient.get_file_info(fastDfsFile.getGroupName(), fastDfsFile.getFileName());
        }
        catch (IOException e) {
            logger.error("IO Exception: Get File from Fast DFS failed", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Non IO Exception: Get File from Fast DFS failed", (Throwable)e);
        }
        return null;
    }

    public void deleteFile(String groupName, String remoteFileName) throws Exception {
        this.storageClient.delete_file(groupName, remoteFileName);
    }

    static {
        try {
            String path = FileManager.class.getResource("/").toString().replace("file:/", "");
            org.csource.fastdfs.ClientGlobal.init(path + "fdfs_client.conf");
            ClientGlobal.init(path + "fdht_client.conf");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }
}

