/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.cache.shiro;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;
import top.ibase4j.core.util.SerializeUtil;

public class RedisSessionDAO
extends AbstractSessionDAO {
    private static final int EXPIRE_TIME = 600;
    @Autowired
    private RedisTemplate<Serializable, Serializable> redisTemplate;

    private RedisConnection getRedisConnection() {
        return this.redisTemplate.getConnectionFactory().getConnection();
    }

    public void update(Session session) throws UnknownSessionException {
        this.saveSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Session session) {
        Serializable id;
        if (session != null && (id = session.getId()) != null) {
            try (RedisConnection redisConnection = this.getRedisConnection();){
                redisConnection.del((byte[][])new byte[][]{this.buildRedisSessionKey(id)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Session> getActiveSessions() {
        ArrayList<Session> list = InstanceUtil.newArrayList();
        try (RedisConnection redisConnection = this.getRedisConnection();){
            Set set = redisConnection.keys("S:iBase4J:SHIRO-SESSION:*".getBytes());
            for (byte[] key : set) {
                list.add((Session)SerializeUtil.deserialize(redisConnection.get(key), SimpleSession.class));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Serializable sessionId) {
        if (sessionId != null) {
            byte[] sessionKey = this.buildRedisSessionKey(sessionId);
            try (RedisConnection redisConnection = this.getRedisConnection();){
                redisConnection.del((byte[][])new byte[][]{sessionKey});
            }
        }
    }

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.saveSession(session);
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session doReadSession(Serializable sessionId) {
        byte[] sessionKey = this.buildRedisSessionKey(sessionId);
        try (RedisConnection redisConnection = this.getRedisConnection();){
            Session session;
            byte[] value = redisConnection.get(sessionKey);
            if (value == null) {
                Session session2 = null;
                return session2;
            }
            Session session3 = session = (Session)SerializeUtil.deserialize(value, SimpleSession.class);
            return session3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSession(Session session) {
        if (session == null || session.getId() == null) {
            throw new UnknownSessionException("session is empty");
        }
        byte[] sessionKey = this.buildRedisSessionKey(session.getId());
        int sessionTimeOut = PropertiesUtil.getInt("session.maxInactiveInterval", 600);
        byte[] value = SerializeUtil.serialize(session);
        try (RedisConnection redisConnection = this.getRedisConnection();){
            redisConnection.set(sessionKey, value, Expiration.seconds((long)sessionTimeOut), RedisStringCommands.SetOption.UPSERT);
        }
    }

    private byte[] buildRedisSessionKey(Serializable sessionId) {
        return ("S:iBase4J:SHIRO-SESSION:" + sessionId).getBytes();
    }
}

