/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.cache.shiro;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.util.CollectionUtils;
import top.ibase4j.core.util.CacheUtil;

public class RedisCache<K, V>
implements Cache<K, V> {
    private final Logger logger = LogManager.getLogger();
    private String keyPrefix = "S:iBase4J:SHIRO-CACHE:";

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public RedisCache(String prefix) {
        this.keyPrefix = prefix;
    }

    public V get(K key) throws CacheException {
        this.logger.debug("\u6839\u636ekey\u4eceRedis\u4e2d\u83b7\u53d6\u5bf9\u8c61 key [" + key + "]");
        Object value = CacheUtil.getCache().getFire(this.getKey(key));
        return (V)value;
    }

    public V put(K key, V value) throws CacheException {
        this.logger.debug("\u6839\u636ekey\u4ece\u5b58\u50a8 key [" + key + "]");
        CacheUtil.getCache().set(this.getKey(key), (Serializable)value);
        return value;
    }

    public V remove(K key) throws CacheException {
        this.logger.debug("\u4eceredis\u4e2d\u5220\u9664 key [" + key + "]");
        V previous = this.get(key);
        CacheUtil.getCache().del(this.getKey(key));
        return previous;
    }

    public void clear() throws CacheException {
        this.logger.debug("\u4eceredis\u4e2d\u5220\u9664\u6240\u6709\u5143\u7d20");
        CacheUtil.getCache().delAll(this.keyPrefix + "*");
    }

    public int size() {
        return CacheUtil.getCache().getAll(this.keyPrefix + "*").size();
    }

    public Set<K> keys() {
        Set<Object> keys = CacheUtil.getCache().getAll(this.keyPrefix + "*");
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptySet();
        }
        HashSet<Object> newKeys = new HashSet<Object>();
        for (Object key : keys) {
            newKeys.add(key);
        }
        return newKeys;
    }

    public Collection<V> values() {
        Set<Object> keys = CacheUtil.getCache().getAll(this.keyPrefix + "*");
        if (!CollectionUtils.isEmpty(keys)) {
            ArrayList<V> values = new ArrayList<V>(keys.size());
            for (Object key : keys) {
                V value = this.get(key);
                if (value == null) continue;
                values.add(value);
            }
            return Collections.unmodifiableList(values);
        }
        return Collections.emptyList();
    }

    private String getKey(K key) {
        return this.keyPrefix + key;
    }
}

