/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.config;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import top.ibase4j.core.util.PropertiesUtil;

public class RpcConfig {

    @Configuration
    @Conditional(value={EnableMotan.class})
    @ImportResource(value={"classpath*:spring/motan.xml"})
    static class MotanConfig {
        MotanConfig() {
        }
    }

    @Configuration
    @Conditional(value={EnableDubbo.class})
    @ImportResource(value={"classpath*:spring/dubbo.xml"})
    static class DubboConfig {
        DubboConfig() {
        }
    }

    public static class EnableMotan
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return "motan".equals(PropertiesUtil.getString("rpc.type"));
        }
    }

    public static class EnableDubbo
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return "dubbo".equals(PropertiesUtil.getString("rpc.type"));
        }
    }
}

