/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.base;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;
import top.ibase4j.core.Constants;
import top.ibase4j.core.base.BaseMapper;
import top.ibase4j.core.base.BaseModel;
import top.ibase4j.core.exception.BusinessException;
import top.ibase4j.core.util.CacheUtil;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.ExceptionUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;

public abstract class BaseService<T extends BaseModel>
implements ApplicationContextAware {
    protected Logger logger = LogManager.getLogger();
    @Autowired
    protected BaseMapper<T> mapper;
    protected ApplicationContext applicationContext;
    int maxThread = PropertiesUtil.getInt("db.reader.list.maxThread", 50);
    int threadSleep = PropertiesUtil.getInt("db.reader.list.threadWait", 5);
    ExecutorService executorService = Executors.newFixedThreadPool(this.maxThread);

    public static Page<Long> getPage(Map<String, Object> params) {
        Object filter;
        Integer current = 1;
        Integer size = 10;
        String orderBy = "id_";
        String sortAsc = null;
        String openSort = "Y";
        if (DataUtil.isNotEmpty(params.get("pageNumber"))) {
            current = Integer.valueOf(params.get("pageNumber").toString());
        }
        if (DataUtil.isNotEmpty(params.get("pageIndex"))) {
            current = Integer.valueOf(params.get("pageIndex").toString());
        }
        if (DataUtil.isNotEmpty(params.get("pageSize"))) {
            size = Integer.valueOf(params.get("pageSize").toString());
        }
        if (DataUtil.isNotEmpty(params.get("limit"))) {
            size = Integer.valueOf(params.get("limit").toString());
        }
        if (DataUtil.isNotEmpty(params.get("offset"))) {
            current = Integer.valueOf(params.get("offset").toString()) / size + 1;
        }
        if (DataUtil.isNotEmpty(params.get("sort"))) {
            orderBy = (String)params.get("sort");
            params.remove("sort");
        }
        if (DataUtil.isNotEmpty(params.get("orderBy"))) {
            orderBy = (String)params.get("orderBy");
            params.remove("orderBy");
        }
        if (DataUtil.isNotEmpty(params.get("sortAsc"))) {
            sortAsc = (String)params.get("sortAsc");
            params.remove("sortAsc");
        }
        if (DataUtil.isNotEmpty(params.get("openSort"))) {
            openSort = (String)params.get("openSort");
            params.remove("openSort");
        }
        if ((filter = params.get("filter")) != null) {
            params.putAll((Map)JSON.parseObject((String)filter.toString(), Map.class));
        }
        if (size == -1) {
            Page page = new Page();
            page.setOrderByField(orderBy);
            page.setAsc("Y".equals(sortAsc));
            page.setOpenSort("Y".equals(openSort));
            return page;
        }
        Page page = new Page(current.intValue(), size.intValue(), orderBy);
        page.setAsc("Y".equals(sortAsc));
        page.setOpenSort("Y".equals(openSort));
        return page;
    }

    @Transactional
    public void del(Long id, Long userId) {
        try {
            T record = this.queryById(id);
            ((BaseModel)record).setEnable(0);
            ((BaseModel)record).setUpdateTime(new Date());
            ((BaseModel)record).setUpdateBy(userId);
            this.mapper.updateById(record);
            try {
                CacheUtil.getCache().set(this.getCacheKey(id), (Serializable)record);
            }
            catch (Exception e) {
                this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Transactional
    public void delete(Long id) {
        try {
            this.mapper.deleteById(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            CacheUtil.getCache().del(this.getCacheKey(id));
        }
        catch (Exception e) {
            this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
        }
    }

    @Transactional
    public Integer deleteByEntity(T t) {
        EntityWrapper wrapper = new EntityWrapper(t);
        return this.mapper.delete((Wrapper)wrapper);
    }

    @Transactional
    public Integer deleteByMap(Map<String, Object> columnMap) {
        return this.mapper.deleteByMap(columnMap);
    }

    public List<T> getList(final List<Long> ids) {
        final ArrayList list = InstanceUtil.newArrayList();
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                list.add(null);
            }
            final ConcurrentHashMap thread = InstanceUtil.newConcurrentHashMap();
            int i = 0;
            while (i < ids.size()) {
                final int index = i++;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            list.set(index, BaseService.this.queryById((Long)ids.get(index)));
                        }
                        finally {
                            thread.put(index, 0);
                        }
                    }
                });
            }
            while (thread.size() < list.size()) {
                try {
                    Thread.sleep(this.threadSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
        }
        return list;
    }

    public <K> List<K> getList(final List<Long> ids, final Class<K> cls) {
        final ArrayList list = InstanceUtil.newArrayList();
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                list.add(null);
            }
            final ConcurrentHashMap thread = InstanceUtil.newConcurrentHashMap();
            int i = 0;
            while (i < ids.size()) {
                final int index = i++;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Object t = BaseService.this.queryById((Long)ids.get(index));
                            Object k = InstanceUtil.to(t, cls);
                            list.set(index, k);
                        }
                        finally {
                            thread.put(index, 0);
                        }
                    }
                });
            }
            while (thread.size() < list.size()) {
                try {
                    Thread.sleep(this.threadSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
        }
        return list;
    }

    public Page<Map<String, Object>> getPageMap(final Page<Long> ids) {
        if (ids != null) {
            Page page = new Page(ids.getCurrent(), ids.getSize());
            page.setTotal(ids.getTotal());
            final ArrayList records = InstanceUtil.newArrayList();
            for (int i = 0; i < ids.getRecords().size(); ++i) {
                records.add(null);
            }
            final ConcurrentHashMap thread = InstanceUtil.newConcurrentHashMap();
            int i = 0;
            while (i < ids.getRecords().size()) {
                final int index = i++;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            records.set(index, InstanceUtil.transBean2Map(BaseService.this.queryById((Long)ids.getRecords().get(index))));
                        }
                        finally {
                            thread.put(index, 0);
                        }
                    }
                });
            }
            while (thread.size() < records.size()) {
                try {
                    Thread.sleep(this.threadSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
            page.setRecords(records);
            return page;
        }
        return new Page();
    }

    public Page<T> query(Map<String, Object> params) {
        Page<Long> page = BaseService.getPage(params);
        page.setRecords(this.mapper.selectIdPage((RowBounds)page, params));
        return this.getPage(page);
    }

    @Transactional
    public T queryById(Long id) {
        return this.queryById(id, 1);
    }

    public List<T> queryList(Map<String, Object> params) {
        List<Long> ids = this.mapper.selectIdPage(params);
        List<T> list = this.getList(ids);
        return list;
    }

    public List<T> selectList(Wrapper<T> entity) {
        return this.mapper.selectList(entity);
    }

    public T selectOne(T entity) {
        return (T)((BaseModel)this.mapper.selectOne(entity));
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public T update(T record) {
        block15: {
            try {
                ((BaseModel)record).setUpdateTime(new Date());
                if (((BaseModel)record).getId() == null) {
                    ((BaseModel)record).setCreateTime(new Date());
                    this.mapper.insert(record);
                    try {
                        record = (BaseModel)this.mapper.selectById(((BaseModel)record).getId());
                        CacheUtil.getCache().set(this.getCacheKey(((BaseModel)record).getId()), (Serializable)record);
                    }
                    catch (Exception e) {
                        this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
                    }
                    break block15;
                }
                String lockKey = this.getLockKey("U" + ((BaseModel)record).getId());
                if (CacheUtil.tryLock(lockKey)) {
                    try {
                        BaseModel org = null;
                        String key = this.getCacheKey(((BaseModel)record).getId());
                        try {
                            org = (BaseModel)CacheUtil.getCache().getFire(key);
                        }
                        catch (Exception e) {
                            this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
                        }
                        if (org == null) {
                            org = (BaseModel)this.mapper.selectById(((BaseModel)record).getId());
                        }
                        BaseModel update = (BaseModel)InstanceUtil.getDiff(org, record);
                        update.setId(((BaseModel)record).getId());
                        this.mapper.updateById(update);
                        record = (BaseModel)this.mapper.selectById(((BaseModel)record).getId());
                        try {
                            CacheUtil.getCache().set(key, (Serializable)record);
                        }
                        catch (Exception e) {
                            this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
                        }
                        break block15;
                    }
                    finally {
                        CacheUtil.unlock(lockKey);
                    }
                }
                throw new RuntimeException("\u6570\u636e\u4e0d\u4e00\u81f4!\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u7f16\u8f91!");
            }
            catch (DuplicateKeyException e) {
                this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
                throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55.");
            }
            catch (Exception e) {
                this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
                throw new RuntimeException(ExceptionUtil.getStackTraceAsString(e));
            }
        }
        return (T)record;
    }

    protected String getCacheKey(Object id) {
        String cacheName = this.getCacheKey();
        return "iBase4J:" + cacheName + ":" + id;
    }

    protected String getLockKey(Object id) {
        String cacheName = this.getCacheKey();
        return "iBase4J:" + cacheName + ":LOCK:" + id;
    }

    protected <P> Page<P> query(Map<String, Object> params, Class<P> cls) {
        Page<Long> page = BaseService.getPage(params);
        page.setRecords(this.mapper.selectIdPage((RowBounds)page, params));
        return this.getPage(page, cls);
    }

    protected void sleep(int millis) {
        try {
            Thread.sleep(RandomUtils.nextLong((long)10L, (long)millis));
        }
        catch (InterruptedException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    private String getCacheKey() {
        Class<?> cls = this.getClass();
        String cacheName = Constants.cacheKeyMap.get(cls);
        if (StringUtils.isBlank((CharSequence)cacheName)) {
            CacheConfig cacheConfig = cls.getAnnotation(CacheConfig.class);
            cacheName = cacheConfig != null && ArrayUtils.isNotEmpty((Object[])cacheConfig.cacheNames()) ? cacheConfig.cacheNames()[0] : this.getClass().getName();
            Constants.cacheKeyMap.put(cls, cacheName);
        }
        return cacheName;
    }

    private Page<T> getPage(final Page<Long> ids) {
        if (ids != null) {
            Page page = new Page(ids.getCurrent(), ids.getSize());
            page.setTotal(ids.getTotal());
            final ArrayList records = InstanceUtil.newArrayList();
            for (int i = 0; i < ids.getRecords().size(); ++i) {
                records.add(null);
            }
            final ConcurrentHashMap thread = InstanceUtil.newConcurrentHashMap();
            int i = 0;
            while (i < ids.getRecords().size()) {
                final int index = i++;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            records.set(index, BaseService.this.queryById((Long)ids.getRecords().get(index)));
                        }
                        finally {
                            thread.put(index, 0);
                        }
                    }
                });
            }
            while (thread.size() < records.size()) {
                try {
                    Thread.sleep(this.threadSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
            page.setRecords(records);
            return page;
        }
        return new Page();
    }

    private <K> Page<K> getPage(final Page<Long> ids, final Class<K> cls) {
        if (ids != null) {
            Page page = new Page(ids.getCurrent(), ids.getSize());
            page.setTotal(ids.getTotal());
            final ArrayList records = InstanceUtil.newArrayList();
            for (int i = 0; i < ids.getRecords().size(); ++i) {
                records.add(null);
            }
            final ConcurrentHashMap thread = InstanceUtil.newConcurrentHashMap();
            int i = 0;
            while (i < ids.getRecords().size()) {
                final int index = i++;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Object t = BaseService.this.queryById((Long)ids.getRecords().get(index));
                            Object k = InstanceUtil.to(t, cls);
                            records.set(index, k);
                        }
                        finally {
                            thread.put(index, 0);
                        }
                    }
                });
            }
            while (thread.size() < records.size()) {
                try {
                    Thread.sleep(this.threadSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
            page.setRecords(records);
            return page;
        }
        return new Page();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T queryById(Long id, int times) {
        String key = this.getCacheKey(id);
        BaseModel record = null;
        try {
            record = (BaseModel)CacheUtil.getCache().getFire(key);
        }
        catch (Exception e) {
            this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
        }
        if (record == null) {
            String lockKey = this.getLockKey(id);
            if (CacheUtil.tryLock(lockKey)) {
                try {
                    record = (BaseModel)this.mapper.selectById(id);
                    try {
                        CacheUtil.getCache().set(key, record);
                    }
                    catch (Exception e) {
                        this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
                    }
                }
                finally {
                    CacheUtil.unlock(lockKey);
                }
            } else {
                if (times > 3) {
                    return (T)((BaseModel)this.mapper.selectById(id));
                }
                this.logger.debug(this.getClass().getSimpleName() + ":" + id + " retry queryById.");
                this.sleep(20);
                return this.queryById(id, times + 1);
            }
        }
        return (T)record;
    }
}

