/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.base;

import com.baomidou.mybatisplus.plugins.Page;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import top.ibase4j.core.base.BaseController;
import top.ibase4j.core.base.BaseModel;
import top.ibase4j.core.base.BaseProvider;
import top.ibase4j.core.base.Parameter;

public abstract class AbstractController<T extends BaseProvider>
extends BaseController {
    protected Logger logger = LogManager.getLogger();
    @Autowired
    protected T provider;

    public abstract String getService();

    public Object query(ModelMap modelMap, Map<String, Object> param) {
        if (param.get("keyword") == null && param.get("search") != null) {
            param.put("keyword", param.get("search"));
            param.remove("search");
        }
        Parameter parameter = new Parameter(this.getService(), "query", param);
        this.logger.info("{} execute query start...", (Object)parameter.getNo());
        Page<?> list = this.provider.execute(parameter).getResultPage();
        this.logger.info("{} execute query end.", (Object)parameter.getNo());
        return this.setSuccessModelMap(modelMap, list);
    }

    public Object queryList(ModelMap modelMap, Map<String, Object> param) {
        Parameter parameter = new Parameter(this.getService(), "queryList", param);
        this.logger.info("{} execute queryList start...", (Object)parameter.getNo());
        List<?> list = this.provider.execute(parameter).getResultList();
        this.logger.info("{} execute queryList end.", (Object)parameter.getNo());
        return this.setSuccessModelMap(modelMap, list);
    }

    public Object get(ModelMap modelMap, BaseModel param) {
        Parameter parameter = new Parameter(this.getService(), "queryById", param.getId());
        this.logger.info("{} execute queryById start...", (Object)parameter.getNo());
        Object result = this.provider.execute(parameter).getResult();
        this.logger.info("{} execute queryById end.", (Object)parameter.getNo());
        return this.setSuccessModelMap(modelMap, result);
    }

    public Object update(ModelMap modelMap, BaseModel param) {
        Long userId = this.getCurrUser();
        if (param.getId() == null) {
            param.setCreateBy(userId);
            param.setCreateTime(new Date());
        }
        param.setUpdateBy(userId);
        param.setUpdateTime(new Date());
        Parameter parameter = new Parameter(this.getService(), "update", param);
        this.logger.info("{} execute update start...", (Object)parameter.getNo());
        this.provider.execute(parameter);
        this.logger.info("{} execute update end.", (Object)parameter.getNo());
        return this.setSuccessModelMap(modelMap);
    }

    public Object delete(ModelMap modelMap, BaseModel param) {
        Parameter parameter = new Parameter(this.getService(), "delete", param.getId());
        this.logger.info("{} execute delete start...", (Object)parameter.getNo());
        this.provider.execute(parameter);
        this.logger.info("{} execute delete end.", (Object)parameter.getNo());
        return this.setSuccessModelMap(modelMap);
    }
}

