/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdht;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Comparator;
import org.csource.common.IniFileReader;
import org.csource.common.MyException;
import org.csource.fastdht.ClientGlobal;
import org.csource.fastdht.ProtoCommon;
import org.csource.fastdht.ServerInfo;

public class ServerGroup {
    protected ServerInfo[] servers;
    protected ServerInfo[][] groups;
    protected boolean keep_alive;

    protected ServerGroup() {
    }

    public ServerGroup(ServerInfo[] servers, ServerInfo[][] groups, boolean keep_alive) {
        this.servers = servers;
        this.groups = groups;
        this.keep_alive = keep_alive;
    }

    public void setKeepAlive(boolean keep_alive) {
        this.keep_alive = keep_alive;
    }

    public boolean getKeepAlive() {
        return this.keep_alive;
    }

    public int getGroupCount() {
        return this.groups.length;
    }

    public ServerInfo[][] getGroups() {
        return this.groups;
    }

    public int getServerCount() {
        return this.servers.length;
    }

    public ServerInfo[] getServers() {
        return this.servers;
    }

    public Object clone() {
        int i;
        ServerComparator compObj = new ServerComparator();
        ServerGroup serverGroup = new ServerGroup();
        serverGroup.servers = new ServerInfo[this.servers.length];
        for (i = 0; i < this.servers.length; ++i) {
            serverGroup.servers[i] = new ServerInfo(this.servers[i].address);
        }
        serverGroup.groups = new ServerInfo[this.groups.length][];
        for (i = 0; i < this.groups.length; ++i) {
            ServerInfo[] group_servers = new ServerInfo[this.groups[i].length];
            for (int k = 0; k < group_servers.length; ++k) {
                int index = Arrays.binarySearch(serverGroup.servers, this.groups[i][k], compObj);
                group_servers[k] = serverGroup.servers[index];
            }
            serverGroup.groups[i] = group_servers;
        }
        serverGroup.keep_alive = this.keep_alive;
        return serverGroup;
    }

    public static ServerGroup loadFromFile(IniFileReader iniReader) throws MyException {
        ServerComparator compObj = new ServerComparator();
        ServerGroup serverGroup = new ServerGroup();
        int keep_alive = iniReader.getIntValue("keep_alive", 0);
        serverGroup.keep_alive = keep_alive != 0;
        int group_count = iniReader.getIntValue("group_count", 0);
        if (group_count <= 0) {
            throw new MyException("Invalid group_count: " + group_count);
        }
        serverGroup.groups = new ServerInfo[group_count][];
        serverGroup.servers = new ServerInfo[0];
        for (int i = 0; i < group_count; ++i) {
            String[] szServers = iniReader.getValues("group" + i);
            if (szServers == null || szServers.length == 0) {
                throw new MyException("item \"group" + i + "\" in " + iniReader.getConfFilename() + " not found");
            }
            serverGroup.groups[i] = new ServerInfo[0];
            for (int k = 0; k < szServers.length; ++k) {
                ServerInfo[] servers;
                String[] parts = szServers[k].split("\\:", 2);
                if (parts.length != 2) {
                    throw new MyException("the value of item \"group" + i + "\" is invalid, the correct format is host:port");
                }
                ServerInfo serverInfo = new ServerInfo(new InetSocketAddress(parts[0].trim(), Integer.parseInt(parts[1].trim())));
                int server_index = Arrays.binarySearch(serverGroup.servers, serverInfo, compObj);
                if (server_index < 0) {
                    servers = new ServerInfo[serverGroup.servers.length + 1];
                    if (serverGroup.servers.length > 0) {
                        System.arraycopy(serverGroup.servers, 0, servers, 0, serverGroup.servers.length);
                    }
                    servers[serverGroup.servers.length] = serverInfo;
                    Arrays.sort(servers, compObj);
                    serverGroup.servers = servers;
                    server_index = Arrays.binarySearch(serverGroup.servers, serverInfo, compObj);
                }
                if (Arrays.binarySearch(serverGroup.groups[i], serverInfo, compObj) >= 0) continue;
                servers = new ServerInfo[serverGroup.groups[i].length + 1];
                if (serverGroup.groups[i].length > 0) {
                    System.arraycopy(serverGroup.groups[i], 0, servers, 0, serverGroup.groups[i].length);
                }
                servers[serverGroup.groups[i].length] = serverGroup.servers[server_index];
                Arrays.sort(servers, compObj);
                serverGroup.groups[i] = servers;
            }
        }
        return serverGroup;
    }

    public boolean connectServer(ServerInfo server) {
        if (server.sock != null) {
            return true;
        }
        try {
            Socket sock = new Socket();
            sock.setReuseAddress(true);
            sock.setSoTimeout(ClientGlobal.g_network_timeout);
            sock.connect(server.address, ClientGlobal.g_network_timeout);
            server.sock = sock;
            return true;
        }
        catch (IOException ex) {
            System.err.println("connect to server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " fail, error info: " + ex.getMessage());
            return false;
        }
    }

    public ServerInfo getServer(int key_hash_code) {
        int server_index;
        int i;
        int group_id = key_hash_code % this.getGroupCount();
        int server_count = this.groups[group_id].length;
        int new_hash_code = key_hash_code << 16 | key_hash_code >> 16;
        if (new_hash_code < 0) {
            new_hash_code &= Integer.MAX_VALUE;
        }
        for (i = server_index = new_hash_code % server_count; i < server_count; ++i) {
            if (!this.connectServer(this.groups[group_id][i])) continue;
            return this.groups[group_id][i];
        }
        for (i = 0; i < server_index; ++i) {
            if (!this.connectServer(this.groups[group_id][i])) continue;
            return this.groups[group_id][i];
        }
        return null;
    }

    public void closeServer(ServerInfo server) {
        if (server.sock == null || this.keep_alive) {
            return;
        }
        try {
            server.sock.close();
            server.sock = null;
        }
        catch (IOException ex) {
            System.err.println("close socket error: " + ex.getMessage());
        }
    }

    public void forceClose(ServerInfo server) {
        if (server == null || server.sock == null) {
            return;
        }
        try {
            if (this.keep_alive) {
                try {
                    ProtoCommon.quit(server.sock);
                }
                catch (IOException ex) {
                    System.err.println("quit error: " + ex.getMessage());
                }
            }
            server.sock.close();
            server.sock = null;
        }
        catch (IOException ex) {
            System.err.println("close socket error: " + ex.getMessage());
        }
    }

    public void closeAll() {
        if (this.servers == null) {
            return;
        }
        for (int i = 0; i < this.servers.length; ++i) {
            this.forceClose(this.servers[i]);
        }
    }

    protected void finalize() throws Throwable {
        this.closeAll();
    }

    public void print() {
        int i;
        System.out.println("group count: " + this.groups.length + ", distinct server count: " + this.servers.length + ", keep_alive=" + this.keep_alive);
        for (i = 0; i < this.servers.length; ++i) {
            System.out.println("server" + (i + 1) + ". " + this.servers[i].address.getAddress().getHostAddress() + ":" + this.servers[i].address.getPort());
        }
        for (i = 0; i < this.groups.length; ++i) {
            System.out.println("group " + i + " server count: " + this.groups[i].length);
            for (int k = 0; k < this.groups[i].length; ++k) {
                System.out.println("server" + (k + 1) + ". " + this.groups[i][k].address.getAddress().getHostAddress() + ":" + this.groups[i][k].address.getPort());
            }
        }
    }

    public static class ServerComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            ServerInfo s1 = (ServerInfo)o1;
            ServerInfo s2 = (ServerInfo)o2;
            int compResult = s1.address.getAddress().getHostAddress().compareTo(s2.address.getAddress().getHostAddress());
            if (compResult != 0) {
                return compResult;
            }
            return s1.address.getPort() - s2.address.getPort();
        }

        @Override
        public boolean equals(Object obj) {
            return this.compare(this, obj) == 0;
        }
    }
}

