/*
 * Decompiled with CFR 0.152.
 */
package top.test.action;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import top.hserver.core.interfaces.HttpRequest;
import top.hserver.core.interfaces.HttpResponse;
import top.hserver.core.ioc.annotation.Autowired;
import top.hserver.core.ioc.annotation.Controller;
import top.hserver.core.ioc.annotation.GET;
import top.hserver.core.ioc.annotation.POST;
import top.hserver.core.server.context.Cookie;
import top.hserver.core.server.context.Response;
import top.hserver.core.server.handlers.FileItem;
import top.hserver.core.server.handlers.StatisticsHandler;
import top.test.bean.User;
import top.test.service.Test;
import top.test.service.UserService;

@Controller
public class Hello {
    @Autowired
    private Test test1q;
    @Autowired
    private UserService userService;

    @GET(value="/")
    public void index(HttpResponse httpResponse) {
        httpResponse.redirect("/hserver.html");
    }

    @GET(value="/hello")
    public Map hello(HttpRequest request, String name) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("code", 200);
        res.put("res", request.getRequestParams());
        res.put("msg", this.test1q.show("xx"));
        res.put("name", name);
        return res;
    }

    @GET(value="/stat")
    public Map stat(String name) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("code", 200);
        res.put("name", name);
        res.put("ipMap", StatisticsHandler.getIpMap());
        res.put("logRequestQue", StatisticsHandler.getLogRequestQue());
        res.put("uniqueIpCount", StatisticsHandler.getUniqueIpCount());
        res.put("count", StatisticsHandler.getCount());
        res.put("uriData", StatisticsHandler.getUriData());
        return res;
    }

    @GET(value="/removeStat")
    public Map removeStat() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("code", 200);
        res.put("ipMap", StatisticsHandler.removeIpMap());
        res.put("logRequestQue", StatisticsHandler.removeLogRequestQue());
        res.put("uniqueIpCount", StatisticsHandler.removeUniqueIpCount());
        res.put("count", StatisticsHandler.removeCount());
        res.put("uriData", StatisticsHandler.removeUriData());
        return res;
    }

    @POST(value="/file")
    public Map file(HttpRequest request) {
        Map<String, FileItem> fileItems = request.getFileItems();
        fileItems.forEach((k, v) -> {
            System.out.println((String)k);
            System.out.println(v);
        });
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("code", 200);
        res.put("res", request.getRequestParams());
        res.put("msg", this.test1q.show("xx"));
        return res;
    }

    @POST(value="/a")
    public Map a(HttpRequest request, Integer a) {
        System.out.println(request.getRequestParams());
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("code", 200);
        res.put("res", request.getRequestParams());
        res.put("msg", this.test1q.show("xx"));
        return res;
    }

    @GET(value="/head")
    public Map head(HttpRequest request, Response response) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("code", 200);
        res.put("msg", this.test1q.show("xx"));
        return res;
    }

    @GET(value="/downFile")
    public void downFile(HttpRequest request, HttpResponse response) {
        response.setDownloadFile(new File("D:\\Java\\HServer\\README.md"));
    }

    @GET(value="/downInputStream")
    public void downInputStream(HttpRequest request, HttpResponse response) throws Exception {
        File file = new File("D:\\Java\\HServer\\README.md");
        FileInputStream fileInputStream = new FileInputStream(file);
        response.setDownloadFile(fileInputStream, "README.md");
    }

    @GET(value="/javaBean")
    public Map javaBean(User user, String name) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("code", 200);
        res.put("msg", this.test1q.show("xx"));
        res.put("user", user);
        res.put("name", name);
        return res;
    }

    @GET(value="/httpResponse")
    public void httpResponse(HttpResponse httpResponse) {
        User user = new User();
        user.setAge(20);
        user.setName("xx");
        user.setSex("\u7537");
        httpResponse.sendJson(user);
    }

    @GET(value="/filter")
    public void Filter() {
    }

    @GET(value="/template")
    public void template(HttpResponse httpResponse) {
        User user = new User();
        user.setAge(20);
        user.setName("xx");
        user.setSex("\u7537");
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("user", user);
        httpResponse.sendTemplate("a.ftl", obj);
    }

    @GET(value="/headers")
    public Map<String, String> headers(HttpRequest request, HttpResponse httpResponse) {
        Cookie cookie = new Cookie().add("name", "\u5f20\u4e09").add("age", "20");
        cookie.setPath("/");
        cookie.setMaxAge(20);
        httpResponse.addCookie(cookie);
        return request.getHeaders();
    }

    @GET(value="/redirect")
    public void redirect(HttpResponse httpResponse) {
        httpResponse.redirect("http://baidu.com");
    }

    @GET(value="/error")
    public String error(HttpResponse httpResponse) {
        return 1 / 0 + "x";
    }

    @GET(value="/config")
    public Map<String, Object> config() {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("user1", this.userService.getUser1());
        obj.put("user2", this.userService.getUser2());
        return obj;
    }
}

