/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.router;

import io.netty.handler.codec.http.HttpMethod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.server.router.RouterInfo;

public class RouterManager {
    private static final Logger log = LoggerFactory.getLogger(RouterManager.class);
    private static final Map<String, RouterInfo> routerGets = new ConcurrentHashMap<String, RouterInfo>();
    private static final Map<String, RouterInfo> routerPosts = new ConcurrentHashMap<String, RouterInfo>();

    public static void addRouter(RouterInfo routerInfo) {
        if (routerInfo != null) {
            String url = routerInfo.getUrl();
            if (HttpMethod.GET == routerInfo.reqMethodName) {
                if (routerGets.containsKey(url)) {
                    log.warn("url<" + url + ">\u6620\u5c04\u5df2\u7ecf\u5b58\u5728\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u7a0b\u5e8f\u4f7f\u7528");
                }
                routerGets.put(url, routerInfo);
            } else {
                if (routerPosts.containsKey(url)) {
                    log.warn("url<" + url + ">\u6620\u5c04\u5df2\u7ecf\u5b58\u5728\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u7a0b\u5e8f\u4f7f\u7528");
                }
                routerPosts.put(url, routerInfo);
            }
        }
    }

    public static RouterInfo getRouterInfo(String url, HttpMethod requestType) {
        if (HttpMethod.GET == requestType) {
            return routerGets.get(url);
        }
        return routerPosts.get(url);
    }
}

