/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.epoll;

import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;

public class NettyServerGroup {
    private Class<? extends ServerSocketChannel> socketChannel;
    private MultithreadEventLoopGroup boosGroup;
    private MultithreadEventLoopGroup workerGroup;

    NettyServerGroup(Class<? extends ServerSocketChannel> socketChannel, MultithreadEventLoopGroup boosGroup, MultithreadEventLoopGroup workerGroup) {
        this.socketChannel = socketChannel;
        this.boosGroup = boosGroup;
        this.workerGroup = workerGroup;
    }

    public static NettyServerGroupBuilder builder() {
        return new NettyServerGroupBuilder();
    }

    public Class<? extends ServerSocketChannel> getSocketChannel() {
        return this.socketChannel;
    }

    public MultithreadEventLoopGroup getBoosGroup() {
        return this.boosGroup;
    }

    public MultithreadEventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public static class NettyServerGroupBuilder {
        private Class<? extends ServerSocketChannel> socketChannel;
        private MultithreadEventLoopGroup boosGroup;
        private MultithreadEventLoopGroup workerGroup;

        NettyServerGroupBuilder() {
        }

        public NettyServerGroupBuilder socketChannel(Class<? extends ServerSocketChannel> socketChannel) {
            this.socketChannel = socketChannel;
            return this;
        }

        public NettyServerGroupBuilder boosGroup(MultithreadEventLoopGroup boosGroup) {
            this.boosGroup = boosGroup;
            return this;
        }

        public NettyServerGroupBuilder workerGroup(MultithreadEventLoopGroup workerGroup) {
            this.workerGroup = workerGroup;
            return this;
        }

        public NettyServerGroup build() {
            return new NettyServerGroup(this.socketChannel, this.boosGroup, this.workerGroup);
        }

        public String toString() {
            return "NettyServerGroup.NettyServerGroupBuilder(socketChannel=" + this.socketChannel + ", boosGroup=" + this.boosGroup + ", workerGroup=" + this.workerGroup + ")";
        }
    }
}

