/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.context;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import top.hserver.core.interfaces.HttpResponse;
import top.hserver.core.server.context.Cookie;
import top.hserver.core.server.util.FreemarkerUtil;

public class Response
implements HttpResponse {
    private Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private File file;
    private InputStream inputStream;
    private boolean isDownload;
    private String fileName;
    private String jsonAndHtml = null;

    @Override
    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    @Override
    public void setDownloadFile(File file) {
        this.file = file;
        this.isDownload = true;
        this.fileName = file.getName();
    }

    @Override
    public void setDownloadFile(InputStream inputStream, String fileName) {
        this.inputStream = inputStream;
        this.isDownload = true;
        this.fileName = fileName;
    }

    @Override
    public void sendJson(Object object) {
        this.jsonAndHtml = JSON.toJSONString((Object)object);
        this.headers.put("content-type", "application/json;charset=UTF-8");
    }

    @Override
    public void sendHtml(String html) {
        this.jsonAndHtml = html;
        this.headers.put("content-type", "text/html;charset=UTF-8");
    }

    @Override
    public void sendTemplate(String htmlPath, Map<String, Object> obj) {
        try {
            this.jsonAndHtml = FreemarkerUtil.getTemplate(htmlPath, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.headers.put("content-type", "text/html;charset=UTF-8");
    }

    @Override
    public void addCookie(Cookie cookie) {
        Iterator iterator = cookie.keySet().iterator();
        StringBuilder cookieStr = new StringBuilder();
        while (iterator.hasNext()) {
            String k = (String)iterator.next();
            String v = (String)cookie.get(k);
            try {
                cookieStr.append(URLEncoder.encode(k, "UTF-8") + "=" + URLEncoder.encode(v, "UTF-8") + ";");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (cookie.getMaxAge() != null) {
            cookieStr.append("Max-Age=");
            cookieStr.append(cookie.getMaxAge());
            cookieStr.append(";");
        }
        if (cookie.getPath() != null) {
            cookieStr.append("path=");
            cookieStr.append(cookie.getPath());
            cookieStr.append(";");
        }
        this.headers.put("Set-Cookie", cookieStr.toString());
    }

    @Override
    public void redirect(String url) {
        this.headers.put("location", url);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public boolean isDownload() {
        return this.isDownload;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getJsonAndHtml() {
        return this.jsonAndHtml;
    }
}

