/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.InitRunner;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.server.HttpNettyServerInitializer;
import top.hserver.core.server.epoll.EpollKit;
import top.hserver.core.server.epoll.NamedThreadFactory;
import top.hserver.core.server.epoll.NettyServerGroup;
import top.hserver.core.task.TaskManager;

public class HServer {
    private static final Logger log = LoggerFactory.getLogger(HServer.class);
    private final int port;

    public HServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        int acceptThreadCount = 1;
        int ioThreadCount = 0;
        System.out.println();
        try {
            String typeName;
            ServerBootstrap bootstrap = new ServerBootstrap();
            if (EpollKit.epollIsAvailable()) {
                bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
                NettyServerGroup nettyServerGroup = EpollKit.group(acceptThreadCount, ioThreadCount);
                bossGroup = nettyServerGroup.getBoosGroup();
                workerGroup = nettyServerGroup.getWorkerGroup();
                bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(nettyServerGroup.getSocketChannel());
                typeName = "Epoll";
            } else {
                bossGroup = new NioEventLoopGroup(acceptThreadCount, (ThreadFactory)new NamedThreadFactory("\u63a5\u6536\u5668@"));
                workerGroup = new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedThreadFactory("\u5de5\u4f5c\u5668@"));
                bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class);
                typeName = "Nio";
            }
            bootstrap.childHandler((ChannelHandler)new HttpNettyServerInitializer());
            Channel ch = bootstrap.bind(this.port).sync().channel();
            log.info("HServer \u542f\u52a8\u5b8c\u6210");
            System.out.println(this.getHello(typeName, this.port));
            System.out.println();
            TaskManager.IS_OK = true;
            InitRunner bean = IocUtil.getBean(InitRunner.class);
            if (bean != null) {
                bean.init();
            }
            ch.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public String getHello(String typeName, int port) {
        return "  ___ ___  _________ \t\u65b9\u5f0f\u8fd0\u884c\uff1a" + typeName + "\t\u7aef\u53e3\uff1a" + port + "\n /   |   \\/   _____/ ______________  __ ___________ \n/    ~    \\_____  \\_/ __ \\_  __ \\  \\/ // __ \\_  __ \\\n\\    Y    /        \\  ___/|  | \\/\\   /\\  ___/|  | \\/\n \\___|_  /_______  /\\___  >__|    \\_/  \\___  >__|   \n       \\/        \\/     \\/                 \\/       ";
    }
}

